(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; locked; preserveAspect; startGroup]
Simulation of Quantum Cryptography
:[font = subsubtitle; inactive; locked; preserveAspect]
Colin P. Williams 
:[font = input; initialization; preserveAspect]
*)
Off[General::spell1]
(*
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; locked; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; locked; preserveAspect]
This Notebook contains code for simulating the action of an idealized quantum cryptography machine (see "Explorations in Quantum Computing", Chapter 8).  Such a machine can be used to establish secret shared keys between two parties who may then send and receive secure messages using a provably secure classical cryptographic scheme such as the one time pad (see the Notebook OneTimePads.ma). 

You are encouraged to work through the Notebook, executing commands labelled as "Try me!" as you go.  To execute a "Try me!" command, position your cursor over the cell containing the command, click the mouse to select the cell and press the SHIFT and RETURN keys simultaneously.

This Notebook contains the following functions:
:[font = input; locked; preserveAspect]
DetectabilityProbability
:[font = text; inactive; locked; preserveAspect]
computes the probability of detecting eavesdropping as a function of the number of bits used in the test for eavesdropping.
:[font = input; locked; preserveAspect]
NumberOfBitsForDetectability
:[font = text; inactive; locked; preserveAspect]
computes the number of bits that Alice and Bob must compare in order to exceed a certain level of detectability.
:[font = input; locked; preserveAspect]
DistributeKeyUsingQKD
:[font = text; inactive; locked; preserveAspect; endGroup]
generates a simulation of the quantum key distribution process.
:[font = section; inactive; preserveAspect; startGroup]
Odds of Detecting Eavesdropping as a Function of the Number of Bits used for the Eavesdropping Test
:[font = text; inactive; preserveAspect]
Our model of quantum cryptography is idealized in the sense that it ignores errors arising from random events during the transmission of the polarized photons.  Hence discrepancies between photons transmitted by Alice and photons received by Bob, when Alice and Bob both know they used the same orientation of polarizers, are attributed to the eavesdropping of a malicious intermediary, called Eve. 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Code
:[font = input; initialization; preserveAspect]
*)
DetectabilityProbability[nBits_]:= N[1 - (3/4)^nBits]

DetectabilityProbability::usage =
	"DetectabilityProbability[n] returns the probability of detecting \
	eavesdropping if n bits are used in the eavesdropping test. To be \
	able to compare a bit, Alice and Bob will have already agreed upon \
	the orientation of their polarizers.";
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
NumberOfBitsForDetectability[probability_]:=
	2 * Ceiling[Log[1-probability]/Log[.75]]

NumberOfBitsForDetectability::usage =
	"NumberOfBitsForDetectability[p] returns (roughly) the number \
	of bits that Alice and Bob need to compare in order to ensure \
	a detection probability of p.  Ignoring errors, for a trial to \
	detect the presence of an eavesdropper, Alice and Bob must pick \
	the same orientation of polarizers and yet measure different bits. \
	Alice and Bob can each use one of two orientations of polarizers \
	and so they will disagree on the choice of orientation about half \
	the time.";

(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
This shows how the probability of detecting eavesdropping varies with the number of bits used in the eavesdropping test.  To be using a bit, Alice and Bob will have already agreed that they were using the same polarizer orientations for the bit in question.
:[font = input; preserveAspect; startGroup]
Plot[DetectabilityProbability[n], {n, 1, 20},
     AxesOrigin->{0,0},
     Frame->True,
     GridLines->{Table[i, {i, 1, 20, 2}], Automatic},
     FrameLabel->{"Number of Bits Tested", "Pr(Detecting Eve)"},
     PlotStyle->Thickness[0.01]];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 -0.182319 0.788138 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(5)] .2619 0 0 2 0 Minner Mrotsboxa
[(10)] .5 0 0 2 0 Minner Mrotsboxa
[(15)] .7381 0 0 2 0 Minner Mrotsboxa
[(20)] .97619 0 0 2 0 Minner Mrotsboxa
[(Number of Bits Tested)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.3)] -0.0125 .05412 1 0 0 Minner Mrotsboxa
[(0.4)] -0.0125 .13294 1 0 0 Minner Mrotsboxa
[(0.5)] -0.0125 .21175 1 0 0 Minner Mrotsboxa
[(0.6)] -0.0125 .29056 1 0 0 Minner Mrotsboxa
[(0.7)] -0.0125 .36938 1 0 0 Minner Mrotsboxa
[(0.8)] -0.0125 .44819 1 0 0 Minner Mrotsboxa
[(0.9)] -0.0125 .527 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60582 1 0 0 Minner Mrotsboxa
[(Pr\(Detecting Eve\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.07143 0 m
.07143 .61803 L
s
P
p
0 0 .5 r
.001 w
.16667 0 m
.16667 .61803 L
s
P
p
0 0 .5 r
.001 w
.2619 0 m
.2619 .61803 L
s
P
p
0 0 .5 r
.001 w
.35714 0 m
.35714 .61803 L
s
P
p
0 0 .5 r
.001 w
.45238 0 m
.45238 .61803 L
s
P
p
0 0 .5 r
.001 w
.54762 0 m
.54762 .61803 L
s
P
p
0 0 .5 r
.001 w
.64286 0 m
.64286 .61803 L
s
P
p
0 0 .5 r
.001 w
.7381 0 m
.7381 .61803 L
s
P
p
0 0 .5 r
.001 w
.83333 0 m
.83333 .61803 L
s
P
p
0 0 .5 r
.001 w
.92857 0 m
.92857 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .05412 m
1 .05412 L
s
P
p
0 0 .5 r
.001 w
0 .13294 m
1 .13294 L
s
P
p
0 0 .5 r
.001 w
0 .21175 m
1 .21175 L
s
P
p
0 0 .5 r
.001 w
0 .29056 m
1 .29056 L
s
P
p
0 0 .5 r
.001 w
0 .36938 m
1 .36938 L
s
P
p
0 0 .5 r
.001 w
0 .44819 m
1 .44819 L
s
P
p
0 0 .5 r
.001 w
0 .527 m
1 .527 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.2619 0 m
.2619 .00625 L
s
P
[(5)] .2619 0 0 2 0 Minner Mrotshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(10)] .5 0 0 2 0 Minner Mrotshowa
p
.002 w
.7381 0 m
.7381 .00625 L
s
P
[(15)] .7381 0 0 2 0 Minner Mrotshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(20)] .97619 0 0 2 0 Minner Mrotshowa
p
.001 w
.07143 0 m
.07143 .00375 L
s
P
p
.001 w
.11905 0 m
.11905 .00375 L
s
P
p
.001 w
.16667 0 m
.16667 .00375 L
s
P
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.30952 0 m
.30952 .00375 L
s
P
p
.001 w
.35714 0 m
.35714 .00375 L
s
P
p
.001 w
.40476 0 m
.40476 .00375 L
s
P
p
.001 w
.45238 0 m
.45238 .00375 L
s
P
p
.001 w
.54762 0 m
.54762 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.64286 0 m
.64286 .00375 L
s
P
p
.001 w
.69048 0 m
.69048 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.83333 0 m
.83333 .00375 L
s
P
p
.001 w
.88095 0 m
.88095 .00375 L
s
P
p
.001 w
.92857 0 m
.92857 .00375 L
s
P
[(Number of Bits Tested)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05412 m
.00625 .05412 L
s
P
[(0.3)] -0.0125 .05412 1 0 0 Minner Mrotshowa
p
.002 w
0 .13294 m
.00625 .13294 L
s
P
[(0.4)] -0.0125 .13294 1 0 0 Minner Mrotshowa
p
.002 w
0 .21175 m
.00625 .21175 L
s
P
[(0.5)] -0.0125 .21175 1 0 0 Minner Mrotshowa
p
.002 w
0 .29056 m
.00625 .29056 L
s
P
[(0.6)] -0.0125 .29056 1 0 0 Minner Mrotshowa
p
.002 w
0 .36938 m
.00625 .36938 L
s
P
[(0.7)] -0.0125 .36938 1 0 0 Minner Mrotshowa
p
.002 w
0 .44819 m
.00625 .44819 L
s
P
[(0.8)] -0.0125 .44819 1 0 0 Minner Mrotshowa
p
.002 w
0 .527 m
.00625 .527 L
s
P
[(0.9)] -0.0125 .527 1 0 0 Minner Mrotshowa
p
.002 w
0 .60582 m
.00625 .60582 L
s
P
[(1)] -0.0125 .60582 1 0 0 Minner Mrotshowa
p
.001 w
0 .06988 m
.00375 .06988 L
s
P
p
.001 w
0 .08565 m
.00375 .08565 L
s
P
p
.001 w
0 .10141 m
.00375 .10141 L
s
P
p
.001 w
0 .11717 m
.00375 .11717 L
s
P
p
.001 w
0 .1487 m
.00375 .1487 L
s
P
p
.001 w
0 .16446 m
.00375 .16446 L
s
P
p
.001 w
0 .18022 m
.00375 .18022 L
s
P
p
.001 w
0 .19599 m
.00375 .19599 L
s
P
p
.001 w
0 .22751 m
.00375 .22751 L
s
P
p
.001 w
0 .24327 m
.00375 .24327 L
s
P
p
.001 w
0 .25904 m
.00375 .25904 L
s
P
p
.001 w
0 .2748 m
.00375 .2748 L
s
P
p
.001 w
0 .30633 m
.00375 .30633 L
s
P
p
.001 w
0 .32209 m
.00375 .32209 L
s
P
p
.001 w
0 .33785 m
.00375 .33785 L
s
P
p
.001 w
0 .35361 m
.00375 .35361 L
s
P
p
.001 w
0 .38514 m
.00375 .38514 L
s
P
p
.001 w
0 .4009 m
.00375 .4009 L
s
P
p
.001 w
0 .41667 m
.00375 .41667 L
s
P
p
.001 w
0 .43243 m
.00375 .43243 L
s
P
p
.001 w
0 .46395 m
.00375 .46395 L
s
P
p
.001 w
0 .47972 m
.00375 .47972 L
s
P
p
.001 w
0 .49548 m
.00375 .49548 L
s
P
p
.001 w
0 .51124 m
.00375 .51124 L
s
P
p
.001 w
0 .54277 m
.00375 .54277 L
s
P
p
.001 w
0 .55853 m
.00375 .55853 L
s
P
p
.001 w
0 .57429 m
.00375 .57429 L
s
P
p
.001 w
0 .59006 m
.00375 .59006 L
s
P
p
.001 w
0 .03836 m
.00375 .03836 L
s
P
p
.001 w
0 .0226 m
.00375 .0226 L
s
P
p
.001 w
0 .00683 m
.00375 .00683 L
s
P
[(Pr\(Detecting Eve\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.2619 .61178 m
.2619 .61803 L
s
P
p
.002 w
.5 .61178 m
.5 .61803 L
s
P
p
.002 w
.7381 .61178 m
.7381 .61803 L
s
P
p
.002 w
.97619 .61178 m
.97619 .61803 L
s
P
p
.001 w
.07143 .61428 m
.07143 .61803 L
s
P
p
.001 w
.11905 .61428 m
.11905 .61803 L
s
P
p
.001 w
.16667 .61428 m
.16667 .61803 L
s
P
p
.001 w
.21429 .61428 m
.21429 .61803 L
s
P
p
.001 w
.30952 .61428 m
.30952 .61803 L
s
P
p
.001 w
.35714 .61428 m
.35714 .61803 L
s
P
p
.001 w
.40476 .61428 m
.40476 .61803 L
s
P
p
.001 w
.45238 .61428 m
.45238 .61803 L
s
P
p
.001 w
.54762 .61428 m
.54762 .61803 L
s
P
p
.001 w
.59524 .61428 m
.59524 .61803 L
s
P
p
.001 w
.64286 .61428 m
.64286 .61803 L
s
P
p
.001 w
.69048 .61428 m
.69048 .61803 L
s
P
p
.001 w
.78571 .61428 m
.78571 .61803 L
s
P
p
.001 w
.83333 .61428 m
.83333 .61803 L
s
P
p
.001 w
.88095 .61428 m
.88095 .61803 L
s
P
p
.001 w
.92857 .61428 m
.92857 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05412 m
1 .05412 L
s
P
p
.002 w
.99375 .13294 m
1 .13294 L
s
P
p
.002 w
.99375 .21175 m
1 .21175 L
s
P
p
.002 w
.99375 .29056 m
1 .29056 L
s
P
p
.002 w
.99375 .36938 m
1 .36938 L
s
P
p
.002 w
.99375 .44819 m
1 .44819 L
s
P
p
.002 w
.99375 .527 m
1 .527 L
s
P
p
.002 w
.99375 .60582 m
1 .60582 L
s
P
p
.001 w
.99625 .06988 m
1 .06988 L
s
P
p
.001 w
.99625 .08565 m
1 .08565 L
s
P
p
.001 w
.99625 .10141 m
1 .10141 L
s
P
p
.001 w
.99625 .11717 m
1 .11717 L
s
P
p
.001 w
.99625 .1487 m
1 .1487 L
s
P
p
.001 w
.99625 .16446 m
1 .16446 L
s
P
p
.001 w
.99625 .18022 m
1 .18022 L
s
P
p
.001 w
.99625 .19599 m
1 .19599 L
s
P
p
.001 w
.99625 .22751 m
1 .22751 L
s
P
p
.001 w
.99625 .24327 m
1 .24327 L
s
P
p
.001 w
.99625 .25904 m
1 .25904 L
s
P
p
.001 w
.99625 .2748 m
1 .2748 L
s
P
p
.001 w
.99625 .30633 m
1 .30633 L
s
P
p
.001 w
.99625 .32209 m
1 .32209 L
s
P
p
.001 w
.99625 .33785 m
1 .33785 L
s
P
p
.001 w
.99625 .35361 m
1 .35361 L
s
P
p
.001 w
.99625 .38514 m
1 .38514 L
s
P
p
.001 w
.99625 .4009 m
1 .4009 L
s
P
p
.001 w
.99625 .41667 m
1 .41667 L
s
P
p
.001 w
.99625 .43243 m
1 .43243 L
s
P
p
.001 w
.99625 .46395 m
1 .46395 L
s
P
p
.001 w
.99625 .47972 m
1 .47972 L
s
P
p
.001 w
.99625 .49548 m
1 .49548 L
s
P
p
.001 w
.99625 .51124 m
1 .51124 L
s
P
p
.001 w
.99625 .54277 m
1 .54277 L
s
P
p
.001 w
.99625 .55853 m
1 .55853 L
s
P
p
.001 w
.99625 .57429 m
1 .57429 L
s
P
p
.001 w
.99625 .59006 m
1 .59006 L
s
P
p
.001 w
.99625 .03836 m
1 .03836 L
s
P
p
.001 w
.99625 .0226 m
1 .0226 L
s
P
p
.001 w
.99625 .00683 m
1 .00683 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.01 w
.07143 .01472 m
.10913 .13511 L
.14683 .23098 L
.18452 .30733 L
.22222 .36812 L
.25992 .41653 L
.29762 .45509 L
.33532 .48579 L
.37302 .51023 L
.41071 .5297 L
.44841 .54521 L
.48611 .55755 L
.52381 .56738 L
.56151 .57521 L
.59921 .58144 L
.6369 .58641 L
.6746 .59036 L
.7123 .59351 L
.75 .59602 L
.7877 .59801 L
.8254 .5996 L
.8631 .60087 L
.90079 .60188 L
.93849 .60268 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
This shows how many bits Alice and Bob must compare in order to ensure that they can detect the presence of an eavesdropper with a probability greater than or equal to p.
:[font = input; preserveAspect; startGroup]
Plot[NumberOfBitsForDetectability[p], {p, 0, 0.999},
		PlotPoints->200,
	 	Frame->True,
     	FrameLabel->{"Detectability Probability p", "Number of Bits Needed"},
     	PlotStyle->Thickness[0.01]];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.953334 0.0147151 0.0117721 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(0.2)] .21448 0 0 2 0 Minner Mrotsboxa
[(0.4)] .40514 0 0 2 0 Minner Mrotsboxa
[(0.6)] .59581 0 0 2 0 Minner Mrotsboxa
[(0.8)] .78648 0 0 2 0 Minner Mrotsboxa
[(1)] .97714 0 0 2 0 Minner Mrotsboxa
[(Detectability Probability p)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 .01472 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .13244 1 0 0 Minner Mrotsboxa
[(20)] -0.0125 .25016 1 0 0 Minner Mrotsboxa
[(30)] -0.0125 .36788 1 0 0 Minner Mrotsboxa
[(40)] -0.0125 .4856 1 0 0 Minner Mrotsboxa
[(50)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(Number of Bits Needed)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.21448 0 m
.21448 .00625 L
s
P
[(0.2)] .21448 0 0 2 0 Minner Mrotshowa
p
.002 w
.40514 0 m
.40514 .00625 L
s
P
[(0.4)] .40514 0 0 2 0 Minner Mrotshowa
p
.002 w
.59581 0 m
.59581 .00625 L
s
P
[(0.6)] .59581 0 0 2 0 Minner Mrotshowa
p
.002 w
.78648 0 m
.78648 .00625 L
s
P
[(0.8)] .78648 0 0 2 0 Minner Mrotshowa
p
.002 w
.97714 0 m
.97714 .00625 L
s
P
[(1)] .97714 0 0 2 0 Minner Mrotshowa
p
.001 w
.06194 0 m
.06194 .00375 L
s
P
p
.001 w
.10008 0 m
.10008 .00375 L
s
P
p
.001 w
.13821 0 m
.13821 .00375 L
s
P
p
.001 w
.17634 0 m
.17634 .00375 L
s
P
p
.001 w
.25261 0 m
.25261 .00375 L
s
P
p
.001 w
.29074 0 m
.29074 .00375 L
s
P
p
.001 w
.32888 0 m
.32888 .00375 L
s
P
p
.001 w
.36701 0 m
.36701 .00375 L
s
P
p
.001 w
.44328 0 m
.44328 .00375 L
s
P
p
.001 w
.48141 0 m
.48141 .00375 L
s
P
p
.001 w
.51954 0 m
.51954 .00375 L
s
P
p
.001 w
.55768 0 m
.55768 .00375 L
s
P
p
.001 w
.63394 0 m
.63394 .00375 L
s
P
p
.001 w
.67208 0 m
.67208 .00375 L
s
P
p
.001 w
.71021 0 m
.71021 .00375 L
s
P
p
.001 w
.74834 0 m
.74834 .00375 L
s
P
p
.001 w
.82461 0 m
.82461 .00375 L
s
P
p
.001 w
.86274 0 m
.86274 .00375 L
s
P
p
.001 w
.90088 0 m
.90088 .00375 L
s
P
p
.001 w
.93901 0 m
.93901 .00375 L
s
P
[(Detectability Probability p)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 0 Minner Mrotshowa
p
.002 w
0 .13244 m
.00625 .13244 L
s
P
[(10)] -0.0125 .13244 1 0 0 Minner Mrotshowa
p
.002 w
0 .25016 m
.00625 .25016 L
s
P
[(20)] -0.0125 .25016 1 0 0 Minner Mrotshowa
p
.002 w
0 .36788 m
.00625 .36788 L
s
P
[(30)] -0.0125 .36788 1 0 0 Minner Mrotshowa
p
.002 w
0 .4856 m
.00625 .4856 L
s
P
[(40)] -0.0125 .4856 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(50)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .03826 m
.00375 .03826 L
s
P
p
.001 w
0 .0618 m
.00375 .0618 L
s
P
p
.001 w
0 .08535 m
.00375 .08535 L
s
P
p
.001 w
0 .10889 m
.00375 .10889 L
s
P
p
.001 w
0 .15598 m
.00375 .15598 L
s
P
p
.001 w
0 .17952 m
.00375 .17952 L
s
P
p
.001 w
0 .20307 m
.00375 .20307 L
s
P
p
.001 w
0 .22661 m
.00375 .22661 L
s
P
p
.001 w
0 .2737 m
.00375 .2737 L
s
P
p
.001 w
0 .29724 m
.00375 .29724 L
s
P
p
.001 w
0 .32079 m
.00375 .32079 L
s
P
p
.001 w
0 .34433 m
.00375 .34433 L
s
P
p
.001 w
0 .39142 m
.00375 .39142 L
s
P
p
.001 w
0 .41497 m
.00375 .41497 L
s
P
p
.001 w
0 .43851 m
.00375 .43851 L
s
P
p
.001 w
0 .46205 m
.00375 .46205 L
s
P
p
.001 w
0 .50914 m
.00375 .50914 L
s
P
p
.001 w
0 .53269 m
.00375 .53269 L
s
P
p
.001 w
0 .55623 m
.00375 .55623 L
s
P
p
.001 w
0 .57977 m
.00375 .57977 L
s
P
[(Number of Bits Needed)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.21448 .61178 m
.21448 .61803 L
s
P
p
.002 w
.40514 .61178 m
.40514 .61803 L
s
P
p
.002 w
.59581 .61178 m
.59581 .61803 L
s
P
p
.002 w
.78648 .61178 m
.78648 .61803 L
s
P
p
.002 w
.97714 .61178 m
.97714 .61803 L
s
P
p
.001 w
.06194 .61428 m
.06194 .61803 L
s
P
p
.001 w
.10008 .61428 m
.10008 .61803 L
s
P
p
.001 w
.13821 .61428 m
.13821 .61803 L
s
P
p
.001 w
.17634 .61428 m
.17634 .61803 L
s
P
p
.001 w
.25261 .61428 m
.25261 .61803 L
s
P
p
.001 w
.29074 .61428 m
.29074 .61803 L
s
P
p
.001 w
.32888 .61428 m
.32888 .61803 L
s
P
p
.001 w
.36701 .61428 m
.36701 .61803 L
s
P
p
.001 w
.44328 .61428 m
.44328 .61803 L
s
P
p
.001 w
.48141 .61428 m
.48141 .61803 L
s
P
p
.001 w
.51954 .61428 m
.51954 .61803 L
s
P
p
.001 w
.55768 .61428 m
.55768 .61803 L
s
P
p
.001 w
.63394 .61428 m
.63394 .61803 L
s
P
p
.001 w
.67208 .61428 m
.67208 .61803 L
s
P
p
.001 w
.71021 .61428 m
.71021 .61803 L
s
P
p
.001 w
.74834 .61428 m
.74834 .61803 L
s
P
p
.001 w
.82461 .61428 m
.82461 .61803 L
s
P
p
.001 w
.86274 .61428 m
.86274 .61803 L
s
P
p
.001 w
.90088 .61428 m
.90088 .61803 L
s
P
p
.001 w
.93901 .61428 m
.93901 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .13244 m
1 .13244 L
s
P
p
.002 w
.99375 .25016 m
1 .25016 L
s
P
p
.002 w
.99375 .36788 m
1 .36788 L
s
P
p
.002 w
.99375 .4856 m
1 .4856 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .03826 m
1 .03826 L
s
P
p
.001 w
.99625 .0618 m
1 .0618 L
s
P
p
.001 w
.99625 .08535 m
1 .08535 L
s
P
p
.001 w
.99625 .10889 m
1 .10889 L
s
P
p
.001 w
.99625 .15598 m
1 .15598 L
s
P
p
.001 w
.99625 .17952 m
1 .17952 L
s
P
p
.001 w
.99625 .20307 m
1 .20307 L
s
P
p
.001 w
.99625 .22661 m
1 .22661 L
s
P
p
.001 w
.99625 .2737 m
1 .2737 L
s
P
p
.001 w
.99625 .29724 m
1 .29724 L
s
P
p
.001 w
.99625 .32079 m
1 .32079 L
s
P
p
.001 w
.99625 .34433 m
1 .34433 L
s
P
p
.001 w
.99625 .39142 m
1 .39142 L
s
P
p
.001 w
.99625 .41497 m
1 .41497 L
s
P
p
.001 w
.99625 .43851 m
1 .43851 L
s
P
p
.001 w
.99625 .46205 m
1 .46205 L
s
P
p
.001 w
.99625 .50914 m
1 .50914 L
s
P
p
.001 w
.99625 .53269 m
1 .53269 L
s
P
p
.001 w
.99625 .55623 m
1 .55623 L
s
P
p
.001 w
.99625 .57977 m
1 .57977 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.01 w
.02381 .01472 m
.02396 .03826 L
.02411 .03826 L
.02441 .03826 L
.02501 .03826 L
.0262 .03826 L
.0286 .03826 L
.03338 .03826 L
.03817 .03826 L
.04295 .03826 L
.04774 .03826 L
.05252 .03826 L
.05731 .03826 L
.0621 .03826 L
.06688 .03826 L
.07167 .03826 L
.07645 .03826 L
.08124 .03826 L
.08603 .03826 L
.09081 .03826 L
.0956 .03826 L
.10038 .03826 L
.10517 .03826 L
.10995 .03826 L
.11474 .03826 L
.11953 .03826 L
.12431 .03826 L
.1291 .03826 L
.13388 .03826 L
.13867 .03826 L
.14346 .03826 L
.14824 .03826 L
.15303 .03826 L
.15781 .03826 L
.1626 .03826 L
.16738 .03826 L
.17217 .03826 L
.17696 .03826 L
.18174 .03826 L
.18653 .03826 L
.19131 .03826 L
.1961 .03826 L
.20089 .03826 L
.20567 .03826 L
.21046 .03826 L
.21524 .03826 L
.22003 .03826 L
.22481 .03826 L
.2296 .03826 L
.23439 .03826 L
Mistroke
.23917 .03826 L
.24396 .03826 L
.24874 .03826 L
.25353 .03826 L
.25832 .03826 L
.25951 .03826 L
.26071 .03826 L
.26131 .03826 L
.26161 .03826 L
.2619 .03826 L
.26205 .03826 L
.2622 .0618 L
.2625 .0618 L
.2631 .0618 L
.26789 .0618 L
.27267 .0618 L
.27746 .0618 L
.28224 .0618 L
.28703 .0618 L
.29182 .0618 L
.2966 .0618 L
.30139 .0618 L
.30617 .0618 L
.31096 .0618 L
.31575 .0618 L
.32053 .0618 L
.32532 .0618 L
.3301 .0618 L
.33489 .0618 L
.33967 .0618 L
.34446 .0618 L
.34925 .0618 L
.35403 .0618 L
.35882 .0618 L
.3636 .0618 L
.36839 .0618 L
.37318 .0618 L
.37796 .0618 L
.38275 .0618 L
.38753 .0618 L
.39232 .0618 L
.3971 .0618 L
.40189 .0618 L
.40668 .0618 L
.41146 .0618 L
.41625 .0618 L
.42103 .0618 L
.42582 .0618 L
.43061 .0618 L
.43539 .0618 L
Mistroke
.43778 .0618 L
.43898 .0618 L
.43958 .0618 L
.44018 .0618 L
.44048 .0618 L
.44063 .0618 L
.44078 .0618 L
.44092 .08535 L
.44107 .08535 L
.44122 .08535 L
.44137 .08535 L
.44257 .08535 L
.44496 .08535 L
.44975 .08535 L
.45453 .08535 L
.45932 .08535 L
.46411 .08535 L
.46889 .08535 L
.47368 .08535 L
.47846 .08535 L
.48325 .08535 L
.48804 .08535 L
.49282 .08535 L
.49761 .08535 L
.50239 .08535 L
.50718 .08535 L
.51196 .08535 L
.51675 .08535 L
.52154 .08535 L
.52632 .08535 L
.53111 .08535 L
.53589 .08535 L
.54068 .08535 L
.54547 .08535 L
.55025 .08535 L
.55504 .08535 L
.55982 .08535 L
.56461 .08535 L
.56939 .08535 L
.57179 .08535 L
.57298 .08535 L
.57358 .08535 L
.57418 .08535 L
.57448 .08535 L
.57463 .08535 L
.57478 .08535 L
.57493 .08535 L
.57508 .10889 L
.57538 .10889 L
.57657 .10889 L
Mistroke
.57897 .10889 L
.58375 .10889 L
.58854 .10889 L
.59332 .10889 L
.59811 .10889 L
.6029 .10889 L
.60768 .10889 L
.61247 .10889 L
.61725 .10889 L
.62204 .10889 L
.62682 .10889 L
.63161 .10889 L
.6364 .10889 L
.64118 .10889 L
.64597 .10889 L
.65075 .10889 L
.65554 .10889 L
.66033 .10889 L
.66511 .10889 L
.6699 .10889 L
.67229 .10889 L
.67349 .10889 L
.67408 .10889 L
.67468 .10889 L
.67498 .10889 L
.67513 .10889 L
.67528 .10889 L
.67543 .10889 L
.67558 .13244 L
.67588 .13244 L
.67708 .13244 L
.67947 .13244 L
.68425 .13244 L
.68904 .13244 L
.69383 .13244 L
.69861 .13244 L
.7034 .13244 L
.70818 .13244 L
.71297 .13244 L
.71776 .13244 L
.72254 .13244 L
.72733 .13244 L
.73211 .13244 L
.7369 .13244 L
.74168 .13244 L
.74408 .13244 L
.74647 .13244 L
.74767 .13244 L
.74886 .13244 L
.74946 .13244 L
Mistroke
.75006 .13244 L
.75036 .13244 L
.75051 .13244 L
.75066 .13244 L
.75081 .13244 L
.75096 .15598 L
.75126 .15598 L
.75604 .15598 L
.76083 .15598 L
.76561 .15598 L
.7704 .15598 L
.77519 .15598 L
.77997 .15598 L
.78476 .15598 L
.78954 .15598 L
.79433 .15598 L
.79911 .15598 L
.80151 .15598 L
.8039 .15598 L
.8051 .15598 L
.8057 .15598 L
.80629 .15598 L
.80689 .15598 L
.80704 .15598 L
.80719 .15598 L
.80734 .15598 L
.80749 .17952 L
.80779 .17952 L
.80809 .17952 L
.80869 .17952 L
.81347 .17952 L
.81826 .17952 L
.82304 .17952 L
.82783 .17952 L
.83262 .17952 L
.8374 .17952 L
.84219 .17952 L
.84458 .17952 L
.84697 .17952 L
.84817 .17952 L
.84877 .17952 L
.84907 .17952 L
.84937 .17952 L
.84966 .17952 L
.84981 .17952 L
.84996 .20307 L
.85056 .20307 L
.85176 .20307 L
.85654 .20307 L
.86133 .20307 L
Mistroke
.86612 .20307 L
.8709 .20307 L
.87569 .20307 L
.87808 .20307 L
.87928 .20307 L
.88047 .20307 L
.88107 .20307 L
.88137 .20307 L
.88152 .20307 L
.88167 .20307 L
.88182 .22661 L
.88197 .22661 L
.88227 .22661 L
.88287 .22661 L
.88526 .22661 L
.89005 .22661 L
.89483 .22661 L
.89962 .22661 L
.90201 .22661 L
.90321 .22661 L
.9038 .22661 L
.9044 .22661 L
.905 .22661 L
.90515 .22661 L
.9053 .22661 L
.90545 .22661 L
.9056 .25016 L
.9059 .25016 L
.9062 .25016 L
.9068 .25016 L
.90919 .25016 L
.91397 .25016 L
.91637 .25016 L
.91876 .25016 L
.91996 .25016 L
.92115 .25016 L
.92175 .25016 L
.92235 .25016 L
.92265 .25016 L
.92295 .25016 L
.9231 .25016 L
.92325 .25016 L
.9234 .25016 L
.92355 .2737 L
.92385 .2737 L
.92414 .2737 L
.92474 .2737 L
.92594 .2737 L
.92833 .2737 L
.93073 .2737 L
Mistroke
.93312 .2737 L
.93431 .2737 L
.93551 .2737 L
.93611 .2737 L
.93641 .2737 L
.93656 .2737 L
.93671 .2737 L
.93686 .2737 L
.93701 .29724 L
.93731 .29724 L
.9379 .29724 L
.9403 .29724 L
.94269 .29724 L
.94389 .29724 L
.94508 .29724 L
.94568 .29724 L
.94628 .29724 L
.94658 .29724 L
.94673 .29724 L
.94688 .29724 L
.94703 .32079 L
.94718 .32079 L
.94748 .32079 L
.94987 .32079 L
.95106 .32079 L
.95226 .32079 L
.95286 .32079 L
.95346 .32079 L
.95376 .32079 L
.95406 .32079 L
.95421 .32079 L
.95436 .32079 L
.9545 .34433 L
.95465 .34433 L
.95495 .34433 L
.95525 .34433 L
.95585 .34433 L
.95705 .34433 L
.95824 .34433 L
.95884 .34433 L
.95944 .34433 L
.95974 .34433 L
.95989 .34433 L
.96004 .34433 L
.96019 .36788 L
.96034 .36788 L
.96064 .36788 L
.96183 .36788 L
.96303 .36788 L
.96363 .36788 L
Mistroke
.96393 .36788 L
.96408 .36788 L
.96423 .36788 L
.96438 .36788 L
.96453 .39142 L
.96467 .39142 L
.96482 .39142 L
.96542 .39142 L
.96602 .39142 L
.96662 .39142 L
.96722 .39142 L
.96737 .39142 L
.96752 .39142 L
.96767 .41497 L
.96782 .41497 L
.96811 .41497 L
.96841 .41497 L
.96901 .41497 L
.96961 .41497 L
.96976 .41497 L
.96991 .41497 L
.97006 .43851 L
.97021 .43851 L
.97051 .43851 L
.97081 .43851 L
.9714 .43851 L
.97155 .43851 L
.9717 .43851 L
.97185 .46205 L
.972 .46205 L
.9723 .46205 L
.9726 .46205 L
.97275 .46205 L
.9729 .46205 L
.97305 .46205 L
.9732 .4856 L
.9735 .4856 L
.9738 .4856 L
.97395 .4856 L
.9741 .4856 L
.97425 .50914 L
.9744 .50914 L
.97455 .50914 L
.97469 .50914 L
.97499 .53269 L
.97619 .60332 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd

:[font = section; inactive; preserveAspect; startGroup]
Encoding Bits Strings in Polarized Photons
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Code
:[font = input; initialization; preserveAspect; endGroup]
*)
EncodeBitString[bitString_]:=
	EncodeBits[Map[ToExpression, Characters[bitString]]]

EncodeBits[bits_]:=
	Map[{#, ChooseBasisForEncoding[], ket[#]}&, bits]
	
ChooseBasisForEncoding[]:=
	If[CoinToss[]===Heads, RectilinearBasis, DiagonalBasis]

(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
 Encode the Bit String "101101110100"
:[font = input; preserveAspect; startGroup]
EncodeBitString["101101110100"]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{{1, RectilinearBasis, ket[1]}, {0, RectilinearBasis, ket[0]}, 
 
  {1, RectilinearBasis, ket[1]}, {1, RectilinearBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {1, RectilinearBasis, ket[1]}, 
 
  {1, DiagonalBasis, ket[1]}, {1, DiagonalBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {1, RectilinearBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {0, RectilinearBasis, ket[0]}}
;[o]
{{1, RectilinearBasis, ket[1]}, {0, RectilinearBasis, ket[0]}, 
 
  {1, RectilinearBasis, ket[1]}, {1, RectilinearBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {1, RectilinearBasis, ket[1]}, 
 
  {1, DiagonalBasis, ket[1]}, {1, DiagonalBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {1, RectilinearBasis, ket[1]}, 
 
  {0, RectilinearBasis, ket[0]}, {0, RectilinearBasis, ket[0]}}
:[font = section; inactive; preserveAspect; startGroup]
Simulating Quantum Key Distribution
:[font = input; preserveAspect; startGroup]
?DistributeKeyUsingQKD
:[font = print; inactive; preserveAspect; endGroup]
DistributeKeyUsingQKD[p, n, options] generates a simulation of quantum key
   distribution.  The desired probability of detecting eavesdropping is p and the
   desired number of bits in the secret shared key is n. If the option
   Eavesdropping->True is given, then the actions of a malicious intermediary Eve are
   simulated. If the option Eavesdropping->False is given, then the simulator runs
   without Eve intervening.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
The following code simulates quantum key distribution in the absence of eavesdropping. The final output is shows Alice's secret key (i.e. sequence of bits) and Bob's secret key. Both keys should be identical.
:[font = input; preserveAspect; startGroup]
SeedRandom[123456];
DistributeKeyUsingQKD[0.75, 5, Eavesdropping->False]
:[font = print; inactive; preserveAspect]
evePresentQ = False
{2, 3, 5, 6, 10, 11, 12, 16, 18, 19, 20, 24, 27, 28, 29}
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 422; pictureHeight = 38; startGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .10323 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00245776 0.952381 [
[ 0 0 0 0 ]
[ 1 .10323 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .10323 L
0 .10323 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00245776 0.97619 0.0331797 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
0 g
p
p
.06338 .02265 m
.07641 .00961 L
s
P
p
.0914 .01613 m
.10983 .01613 L
s
P
p
.12482 .02265 m
.13785 .00961 L
s
P
p
.15554 .02265 m
.16858 .00961 L
s
P
p
.18626 .02265 m
.1993 .00961 L
s
P
p
.21699 .00961 m
.23002 .02265 L
s
P
p
.24771 .00961 m
.26074 .02265 L
s
P
p
.27573 .01613 m
.29416 .01613 L
s
P
p
.30915 .00961 m
.32219 .02265 L
s
P
p
.33987 .02265 m
.35291 .00961 L
s
P
p
.37711 .00691 m
.37711 .02535 L
s
P
p
.40783 .00691 m
.40783 .02535 L
s
P
p
.43856 .00691 m
.43856 .02535 L
s
P
p
.46928 .00691 m
.46928 .02535 L
s
P
p
.49348 .02265 m
.50652 .00961 L
s
P
p
.5242 .00961 m
.53724 .02265 L
s
P
p
.56144 .00691 m
.56144 .02535 L
s
P
p
.59217 .00691 m
.59217 .02535 L
s
P
p
.61637 .00961 m
.6294 .02265 L
s
P
p
.64439 .01613 m
.66283 .01613 L
s
P
p
.68433 .00691 m
.68433 .02535 L
s
P
p
.70854 .00961 m
.72157 .02265 L
s
P
p
.73926 .00961 m
.75229 .02265 L
s
P
p
.7765 .00691 m
.7765 .02535 L
s
P
p
.80722 .00691 m
.80722 .02535 L
s
P
p
.83142 .00961 m
.84446 .02265 L
s
P
p
.86215 .02265 m
.87518 .00961 L
s
P
p
.89939 .00691 m
.89939 .02535 L
s
P
p
.92359 .02265 m
.93662 .00961 L
s
P
p
.95431 .02265 m
.96735 .00961 L
s
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0362519 0.97619 0.0669739 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06338 .00961 m
.07641 .02265 L
s
.06338 .02265 m
.07641 .00961 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
.7 g
.004 w
.15554 .00961 m
.16858 .02265 L
s
.15554 .02265 m
.16858 .00961 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
.7 g
.004 w
.24771 .00961 m
.26074 .02265 L
s
.24771 .02265 m
.26074 .00961 L
s
P
p
.7 g
.004 w
.27573 .01613 m
.29416 .01613 L
s
.28495 .02535 m
.28495 .00691 L
s
P
p
.7 g
.004 w
.30915 .00961 m
.32219 .02265 L
s
.30915 .02265 m
.32219 .00961 L
s
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
.7 g
.004 w
.42934 .01613 m
.44777 .01613 L
s
.43856 .02535 m
.43856 .00691 L
s
P
p
.7 g
.004 w
.46006 .01613 m
.47849 .01613 L
s
.46928 .02535 m
.46928 .00691 L
s
P
p
.7 g
.004 w
.49348 .00961 m
.50652 .02265 L
s
.49348 .02265 m
.50652 .00961 L
s
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
.7 g
.004 w
.55223 .01613 m
.57066 .01613 L
s
.56144 .02535 m
.56144 .00691 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
.7 g
.004 w
.67512 .01613 m
.69355 .01613 L
s
.68433 .02535 m
.68433 .00691 L
s
P
p
.7 g
.004 w
.70854 .00961 m
.72157 .02265 L
s
.70854 .02265 m
.72157 .00961 L
s
P
p
.7 g
.004 w
.73926 .00961 m
.75229 .02265 L
s
.73926 .02265 m
.75229 .00961 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.798 .01613 m
.81644 .01613 L
s
.80722 .02535 m
.80722 .00691 L
s
P
p
.7 g
.004 w
.83142 .00961 m
.84446 .02265 L
s
.83142 .02265 m
.84446 .00961 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95431 .00961 m
.96735 .02265 L
s
.95431 .02265 m
.96735 .00961 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0700461 0.97619 0.100768 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(1)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(1)] .28495 .01613 0 0 Mshowa
[(0)] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[(0)] .43856 .01613 0 0 Mshowa
[(0)] .46928 .01613 0 0 Mshowa
[(1)] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(0)] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[(0)] .68433 .01613 0 0 Mshowa
[(0)] .71505 .01613 0 0 Mshowa
[(0)] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[(0)] .80722 .01613 0 0 Mshowa
[(0)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(1)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 350; pictureHeight = 35]
%!
%%Creator: Mathematica
%%AspectRatio: .10323 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00245776 0.952381 [
[ 0 0 0 0 ]
[ 1 .10323 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .10323 L
0 .10323 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00245776 0.97619 0.0331797 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(0)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(0)] .28495 .01613 0 0 Mshowa
[(1)] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[(0)] .43856 .01613 0 0 Mshowa
[(1)] .46928 .01613 0 0 Mshowa
[(0)] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(0)] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[(1)] .68433 .01613 0 0 Mshowa
[(1)] .71505 .01613 0 0 Mshowa
[(1)] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[(1)] .80722 .01613 0 0 Mshowa
[(1)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(0)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0362519 0.97619 0.0669739 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06068 .01613 m
.07911 .01613 L
s
.06989 .02535 m
.06989 .00691 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
.7 g
.004 w
.15284 .01613 m
.17127 .01613 L
s
.16206 .02535 m
.16206 .00691 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
.7 g
.004 w
.24501 .01613 m
.26344 .01613 L
s
.25422 .02535 m
.25422 .00691 L
s
P
p
.7 g
.004 w
.27843 .00961 m
.29146 .02265 L
s
.27843 .02265 m
.29146 .00961 L
s
P
p
.7 g
.004 w
.30645 .01613 m
.32488 .01613 L
s
.31567 .02535 m
.31567 .00691 L
s
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
.7 g
.004 w
.43204 .00961 m
.44507 .02265 L
s
.43204 .02265 m
.44507 .00961 L
s
P
p
.7 g
.004 w
.46276 .00961 m
.4758 .02265 L
s
.46276 .02265 m
.4758 .00961 L
s
P
p
.7 g
.004 w
.49078 .01613 m
.50922 .01613 L
s
.5 .02535 m
.5 .00691 L
s
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
.7 g
.004 w
.55493 .00961 m
.56796 .02265 L
s
.55493 .02265 m
.56796 .00961 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
.7 g
.004 w
.67781 .00961 m
.69085 .02265 L
s
.67781 .02265 m
.69085 .00961 L
s
P
p
.7 g
.004 w
.70584 .01613 m
.72427 .01613 L
s
.71505 .02535 m
.71505 .00691 L
s
P
p
.7 g
.004 w
.73656 .01613 m
.75499 .01613 L
s
.74578 .02535 m
.74578 .00691 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.8007 .00961 m
.81374 .02265 L
s
.8007 .02265 m
.81374 .00961 L
s
P
p
.7 g
.004 w
.82873 .01613 m
.84716 .01613 L
s
.83794 .02535 m
.83794 .00691 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95161 .01613 m
.97005 .01613 L
s
.96083 .02535 m
.96083 .00691 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0700461 0.97619 0.100768 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
0 g
p
p
.06338 .02265 m
.07641 .00961 L
s
P
p
.0914 .01613 m
.10983 .01613 L
s
P
p
.12482 .02265 m
.13785 .00961 L
s
P
p
.15554 .02265 m
.16858 .00961 L
s
P
p
.18626 .02265 m
.1993 .00961 L
s
P
p
.21699 .00961 m
.23002 .02265 L
s
P
p
.24771 .00961 m
.26074 .02265 L
s
P
p
.27573 .01613 m
.29416 .01613 L
s
P
p
.30915 .00961 m
.32219 .02265 L
s
P
p
.33987 .02265 m
.35291 .00961 L
s
P
p
.37711 .00691 m
.37711 .02535 L
s
P
p
.40783 .00691 m
.40783 .02535 L
s
P
p
.43856 .00691 m
.43856 .02535 L
s
P
p
.46928 .00691 m
.46928 .02535 L
s
P
p
.49348 .02265 m
.50652 .00961 L
s
P
p
.5242 .00961 m
.53724 .02265 L
s
P
p
.56144 .00691 m
.56144 .02535 L
s
P
p
.59217 .00691 m
.59217 .02535 L
s
P
p
.61637 .00961 m
.6294 .02265 L
s
P
p
.64439 .01613 m
.66283 .01613 L
s
P
p
.68433 .00691 m
.68433 .02535 L
s
P
p
.70854 .00961 m
.72157 .02265 L
s
P
p
.73926 .00961 m
.75229 .02265 L
s
P
p
.7765 .00691 m
.7765 .02535 L
s
P
p
.80722 .00691 m
.80722 .02535 L
s
P
p
.83142 .00961 m
.84446 .02265 L
s
P
p
.86215 .02265 m
.87518 .00961 L
s
P
p
.89939 .00691 m
.89939 .02535 L
s
P
p
.92359 .02265 m
.93662 .00961 L
s
P
p
.95431 .02265 m
.96735 .00961 L
s
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 332; pictureHeight = 45]
%!
%%Creator: Mathematica
%%AspectRatio: .13871 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00330261 0.952381 [
[ 0 0 0 0 ]
[ 1 .13871 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .13871 L
0 .13871 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00330261 0.97619 0.0340246 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[( )] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[( )] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[( )] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[( )] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[( )] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0370968 0.97619 0.0678187 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
P
p
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
P
p
P
p
P
p
P
p
P
p
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
P
p
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0708909 0.97619 0.101613 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
P
p
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
P
p
P
p
P
p
P
p
P
p
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
P
p
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.104685 0.97619 0.135407 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[( )] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[( )] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[( )] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[( )] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[( )] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 336; pictureHeight = 58; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .17419 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00414747 0.952381 [
[ 0 0 0 0 ]
[ 1 .17419 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .17419 L
0 .17419 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00414747 0.97619 0.0348694 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[( )] .10061 .01613 0 0 Mshowa
[( )] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[( )] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[( )] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[( )] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[( )] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[( )] .59217 .01613 0 0 Mshowa
[(0)] .62289 .01613 0 0 Mshowa
[( )] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[( )] .86866 .01613 0 0 Mshowa
[( )] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0379416 0.97619 0.0686636 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.004 w
newpath
.06989 .01613 .01229 0 365.73 arc
s
.07358 .01982 m
.07358 .01982 .00184 0 365.73 arc
F
.06621 .01982 m
.06621 .01982 .00184 0 365.73 arc
F
.06621 .01121 m
.06743 .01367 L
.07235 .01367 L
.07358 .01121 L
s
P
p
P
p
P
p
.004 w
newpath
.16206 .01613 .01229 0 365.73 arc
s
.16575 .01982 m
.16575 .01982 .00184 0 365.73 arc
F
.15837 .01982 m
.15837 .01982 .00184 0 365.73 arc
F
.15837 .01121 m
.1596 .01367 L
.16452 .01367 L
.16575 .01121 L
s
P
p
.004 w
newpath
.19278 .01613 .01229 0 365.73 arc
s
.19647 .01982 m
.19647 .01982 .00184 0 365.73 arc
F
.18909 .01982 m
.18909 .01982 .00184 0 365.73 arc
F
.18909 .01367 m
.19032 .01121 L
.19524 .01121 L
.19647 .01367 L
s
P
p
P
p
.004 w
newpath
.25422 .01613 .01229 0 365.73 arc
s
.25791 .01982 m
.25791 .01982 .00184 0 365.73 arc
F
.25054 .01982 m
.25054 .01982 .00184 0 365.73 arc
F
.25054 .01121 m
.25177 .01367 L
.25668 .01367 L
.25791 .01121 L
s
P
p
.004 w
newpath
.28495 .01613 .01229 0 365.73 arc
s
.28863 .01982 m
.28863 .01982 .00184 0 365.73 arc
F
.28126 .01982 m
.28126 .01982 .00184 0 365.73 arc
F
.28126 .01121 m
.28249 .01367 L
.2874 .01367 L
.28863 .01121 L
s
P
p
.004 w
newpath
.31567 .01613 .01229 0 365.73 arc
s
.31935 .01982 m
.31935 .01982 .00184 0 365.73 arc
F
.31198 .01982 m
.31198 .01982 .00184 0 365.73 arc
F
.31198 .01121 m
.31321 .01367 L
.31813 .01367 L
.31935 .01121 L
s
P
p
P
p
.004 w
newpath
.37711 .01613 .01229 0 365.73 arc
s
.3808 .01982 m
.3808 .01982 .00184 0 365.73 arc
F
.37343 .01982 m
.37343 .01982 .00184 0 365.73 arc
F
.37343 .01367 m
.37465 .01121 L
.37957 .01121 L
.3808 .01367 L
s
P
p
P
p
.004 w
newpath
.43856 .01613 .01229 0 365.73 arc
s
.44224 .01982 m
.44224 .01982 .00184 0 365.73 arc
F
.43487 .01982 m
.43487 .01982 .00184 0 365.73 arc
F
.43487 .01121 m
.4361 .01367 L
.44101 .01367 L
.44224 .01121 L
s
P
p
.004 w
newpath
.46928 .01613 .01229 0 365.73 arc
s
.47296 .01982 m
.47296 .01982 .00184 0 365.73 arc
F
.46559 .01982 m
.46559 .01982 .00184 0 365.73 arc
F
.46559 .01121 m
.46682 .01367 L
.47174 .01367 L
.47296 .01121 L
s
P
p
.004 w
newpath
.5 .01613 .01229 0 365.73 arc
s
.50369 .01982 m
.50369 .01982 .00184 0 365.73 arc
F
.49631 .01982 m
.49631 .01982 .00184 0 365.73 arc
F
.49631 .01121 m
.49754 .01367 L
.50246 .01367 L
.50369 .01121 L
s
P
p
P
p
.004 w
newpath
.56144 .01613 .01229 0 365.73 arc
s
.56513 .01982 m
.56513 .01982 .00184 0 365.73 arc
F
.55776 .01982 m
.55776 .01982 .00184 0 365.73 arc
F
.55776 .01121 m
.55899 .01367 L
.5639 .01367 L
.56513 .01121 L
s
P
p
P
p
.004 w
newpath
.62289 .01613 .01229 0 365.73 arc
s
.62657 .01982 m
.62657 .01982 .00184 0 365.73 arc
F
.6192 .01982 m
.6192 .01982 .00184 0 365.73 arc
F
.6192 .01367 m
.62043 .01121 L
.62535 .01121 L
.62657 .01367 L
s
P
p
P
p
.004 w
newpath
.68433 .01613 .01229 0 365.73 arc
s
.68802 .01982 m
.68802 .01982 .00184 0 365.73 arc
F
.68065 .01982 m
.68065 .01982 .00184 0 365.73 arc
F
.68065 .01121 m
.68187 .01367 L
.68679 .01367 L
.68802 .01121 L
s
P
p
.004 w
newpath
.71505 .01613 .01229 0 365.73 arc
s
.71874 .01982 m
.71874 .01982 .00184 0 365.73 arc
F
.71137 .01982 m
.71137 .01982 .00184 0 365.73 arc
F
.71137 .01121 m
.7126 .01367 L
.71751 .01367 L
.71874 .01121 L
s
P
p
.004 w
newpath
.74578 .01613 .01229 0 365.73 arc
s
.74946 .01982 m
.74946 .01982 .00184 0 365.73 arc
F
.74209 .01982 m
.74209 .01982 .00184 0 365.73 arc
F
.74209 .01121 m
.74332 .01367 L
.74823 .01367 L
.74946 .01121 L
s
P
p
.004 w
newpath
.7765 .01613 .01229 0 365.73 arc
s
.78018 .01982 m
.78018 .01982 .00184 0 365.73 arc
F
.77281 .01982 m
.77281 .01982 .00184 0 365.73 arc
F
.77281 .01367 m
.77404 .01121 L
.77896 .01121 L
.78018 .01367 L
s
P
p
.004 w
newpath
.80722 .01613 .01229 0 365.73 arc
s
.81091 .01982 m
.81091 .01982 .00184 0 365.73 arc
F
.80353 .01982 m
.80353 .01982 .00184 0 365.73 arc
F
.80353 .01121 m
.80476 .01367 L
.80968 .01367 L
.81091 .01121 L
s
P
p
.004 w
newpath
.83794 .01613 .01229 0 365.73 arc
s
.84163 .01982 m
.84163 .01982 .00184 0 365.73 arc
F
.83425 .01982 m
.83425 .01982 .00184 0 365.73 arc
F
.83425 .01121 m
.83548 .01367 L
.8404 .01367 L
.84163 .01121 L
s
P
p
P
p
P
p
.004 w
newpath
.93011 .01613 .01229 0 365.73 arc
s
.93379 .01982 m
.93379 .01982 .00184 0 365.73 arc
F
.92642 .01982 m
.92642 .01982 .00184 0 365.73 arc
F
.92642 .01367 m
.92765 .01121 L
.93257 .01121 L
.93379 .01367 L
s
P
p
.004 w
newpath
.96083 .01613 .01229 0 365.73 arc
s
.96452 .01982 m
.96452 .01982 .00184 0 365.73 arc
F
.95714 .01982 m
.95714 .01982 .00184 0 365.73 arc
F
.95714 .01121 m
.95837 .01367 L
.96329 .01367 L
.96452 .01121 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0717358 0.97619 0.102458 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(0)] .06989 .01613 0 0 Mshowa
[( )] .10061 .01613 0 0 Mshowa
[( )] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[( )] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(0)] .28495 .01613 0 0 Mshowa
[(1)] .31567 .01613 0 0 Mshowa
[( )] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[( )] .40783 .01613 0 0 Mshowa
[(0)] .43856 .01613 0 0 Mshowa
[(1)] .46928 .01613 0 0 Mshowa
[(0)] .5 .01613 0 0 Mshowa
[( )] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[( )] .59217 .01613 0 0 Mshowa
[(0)] .62289 .01613 0 0 Mshowa
[( )] .65361 .01613 0 0 Mshowa
[(1)] .68433 .01613 0 0 Mshowa
[(1)] .71505 .01613 0 0 Mshowa
[(1)] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[(1)] .80722 .01613 0 0 Mshowa
[(1)] .83794 .01613 0 0 Mshowa
[( )] .86866 .01613 0 0 Mshowa
[( )] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(0)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.10553 0.97619 0.136252 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06068 .01613 m
.07911 .01613 L
s
.06989 .02535 m
.06989 .00691 L
s
P
p
P
p
P
p
.7 g
.004 w
.15284 .01613 m
.17127 .01613 L
s
.16206 .02535 m
.16206 .00691 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
P
p
.7 g
.004 w
.24501 .01613 m
.26344 .01613 L
s
.25422 .02535 m
.25422 .00691 L
s
P
p
.7 g
.004 w
.27843 .00961 m
.29146 .02265 L
s
.27843 .02265 m
.29146 .00961 L
s
P
p
.7 g
.004 w
.30645 .01613 m
.32488 .01613 L
s
.31567 .02535 m
.31567 .00691 L
s
P
p
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
P
p
.7 g
.004 w
.43204 .00961 m
.44507 .02265 L
s
.43204 .02265 m
.44507 .00961 L
s
P
p
.7 g
.004 w
.46276 .00961 m
.4758 .02265 L
s
.46276 .02265 m
.4758 .00961 L
s
P
p
.7 g
.004 w
.49078 .01613 m
.50922 .01613 L
s
.5 .02535 m
.5 .00691 L
s
P
p
P
p
.7 g
.004 w
.55493 .00961 m
.56796 .02265 L
s
.55493 .02265 m
.56796 .00961 L
s
P
p
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
P
p
.7 g
.004 w
.67781 .00961 m
.69085 .02265 L
s
.67781 .02265 m
.69085 .00961 L
s
P
p
.7 g
.004 w
.70584 .01613 m
.72427 .01613 L
s
.71505 .02535 m
.71505 .00691 L
s
P
p
.7 g
.004 w
.73656 .01613 m
.75499 .01613 L
s
.74578 .02535 m
.74578 .00691 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.8007 .00961 m
.81374 .02265 L
s
.8007 .02265 m
.81374 .00961 L
s
P
p
.7 g
.004 w
.82873 .01613 m
.84716 .01613 L
s
.83794 .02535 m
.83794 .00691 L
s
P
p
P
p
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95161 .01613 m
.97005 .01613 L
s
.96083 .02535 m
.96083 .00691 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.139324 0.97619 0.170046 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06338 .00961 m
.07641 .02265 L
s
.06338 .02265 m
.07641 .00961 L
s
P
p
P
p
P
p
.7 g
.004 w
.15554 .00961 m
.16858 .02265 L
s
.15554 .02265 m
.16858 .00961 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
P
p
.7 g
.004 w
.24771 .00961 m
.26074 .02265 L
s
.24771 .02265 m
.26074 .00961 L
s
P
p
.7 g
.004 w
.27573 .01613 m
.29416 .01613 L
s
.28495 .02535 m
.28495 .00691 L
s
P
p
.7 g
.004 w
.30915 .00961 m
.32219 .02265 L
s
.30915 .02265 m
.32219 .00961 L
s
P
p
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
P
p
.7 g
.004 w
.42934 .01613 m
.44777 .01613 L
s
.43856 .02535 m
.43856 .00691 L
s
P
p
.7 g
.004 w
.46006 .01613 m
.47849 .01613 L
s
.46928 .02535 m
.46928 .00691 L
s
P
p
.7 g
.004 w
.49348 .00961 m
.50652 .02265 L
s
.49348 .02265 m
.50652 .00961 L
s
P
p
P
p
.7 g
.004 w
.55223 .01613 m
.57066 .01613 L
s
.56144 .02535 m
.56144 .00691 L
s
P
p
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
P
p
.7 g
.004 w
.67512 .01613 m
.69355 .01613 L
s
.68433 .02535 m
.68433 .00691 L
s
P
p
.7 g
.004 w
.70854 .00961 m
.72157 .02265 L
s
.70854 .02265 m
.72157 .00961 L
s
P
p
.7 g
.004 w
.73926 .00961 m
.75229 .02265 L
s
.73926 .02265 m
.75229 .00961 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.798 .01613 m
.81644 .01613 L
s
.80722 .02535 m
.80722 .00691 L
s
P
p
.7 g
.004 w
.83142 .00961 m
.84446 .02265 L
s
.83142 .02265 m
.84446 .00961 L
s
P
p
P
p
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95431 .00961 m
.96735 .02265 L
s
.95431 .02265 m
.96735 .00961 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
{{{1}, {0}, {0}, {0}, {1}}, {{1}, {0}, {0}, {0}, {1}}}
;[o]
{{{1}, {0}, {0}, {0}, {1}}, {{1}, {0}, {0}, {0}, {1}}}
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
The following code simulates quantum key distribution in the presence of eavesdropping.
:[font = input; preserveAspect; startGroup]
SeedRandom[123456];
DistributeKeyUsingQKD[0.75, 5, Eavesdropping->True]
:[font = print; inactive; preserveAspect]
evePresentQ = True
{2, 3, 5, 6, 10, 11, 12, 16, 18, 19, 20, 24, 27, 28, 29}
Channel is insecure! Do not exchange a key.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 401; pictureHeight = 38; startGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .10323 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00245776 0.952381 [
[ 0 0 0 0 ]
[ 1 .10323 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .10323 L
0 .10323 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00245776 0.97619 0.0331797 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
0 g
p
p
.06338 .02265 m
.07641 .00961 L
s
P
p
.0914 .01613 m
.10983 .01613 L
s
P
p
.12482 .02265 m
.13785 .00961 L
s
P
p
.15554 .02265 m
.16858 .00961 L
s
P
p
.18626 .02265 m
.1993 .00961 L
s
P
p
.21699 .00961 m
.23002 .02265 L
s
P
p
.24771 .00961 m
.26074 .02265 L
s
P
p
.27573 .01613 m
.29416 .01613 L
s
P
p
.30915 .00961 m
.32219 .02265 L
s
P
p
.33987 .02265 m
.35291 .00961 L
s
P
p
.37711 .00691 m
.37711 .02535 L
s
P
p
.40783 .00691 m
.40783 .02535 L
s
P
p
.43856 .00691 m
.43856 .02535 L
s
P
p
.46928 .00691 m
.46928 .02535 L
s
P
p
.49348 .02265 m
.50652 .00961 L
s
P
p
.5242 .00961 m
.53724 .02265 L
s
P
p
.56144 .00691 m
.56144 .02535 L
s
P
p
.59217 .00691 m
.59217 .02535 L
s
P
p
.61637 .00961 m
.6294 .02265 L
s
P
p
.64439 .01613 m
.66283 .01613 L
s
P
p
.68433 .00691 m
.68433 .02535 L
s
P
p
.70854 .00961 m
.72157 .02265 L
s
P
p
.73926 .00961 m
.75229 .02265 L
s
P
p
.7765 .00691 m
.7765 .02535 L
s
P
p
.80722 .00691 m
.80722 .02535 L
s
P
p
.83142 .00961 m
.84446 .02265 L
s
P
p
.86215 .02265 m
.87518 .00961 L
s
P
p
.89939 .00691 m
.89939 .02535 L
s
P
p
.92359 .02265 m
.93662 .00961 L
s
P
p
.95431 .02265 m
.96735 .00961 L
s
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0362519 0.97619 0.0669739 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06338 .00961 m
.07641 .02265 L
s
.06338 .02265 m
.07641 .00961 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
.7 g
.004 w
.15554 .00961 m
.16858 .02265 L
s
.15554 .02265 m
.16858 .00961 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
.7 g
.004 w
.24771 .00961 m
.26074 .02265 L
s
.24771 .02265 m
.26074 .00961 L
s
P
p
.7 g
.004 w
.27573 .01613 m
.29416 .01613 L
s
.28495 .02535 m
.28495 .00691 L
s
P
p
.7 g
.004 w
.30915 .00961 m
.32219 .02265 L
s
.30915 .02265 m
.32219 .00961 L
s
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
.7 g
.004 w
.42934 .01613 m
.44777 .01613 L
s
.43856 .02535 m
.43856 .00691 L
s
P
p
.7 g
.004 w
.46006 .01613 m
.47849 .01613 L
s
.46928 .02535 m
.46928 .00691 L
s
P
p
.7 g
.004 w
.49348 .00961 m
.50652 .02265 L
s
.49348 .02265 m
.50652 .00961 L
s
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
.7 g
.004 w
.55223 .01613 m
.57066 .01613 L
s
.56144 .02535 m
.56144 .00691 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
.7 g
.004 w
.67512 .01613 m
.69355 .01613 L
s
.68433 .02535 m
.68433 .00691 L
s
P
p
.7 g
.004 w
.70854 .00961 m
.72157 .02265 L
s
.70854 .02265 m
.72157 .00961 L
s
P
p
.7 g
.004 w
.73926 .00961 m
.75229 .02265 L
s
.73926 .02265 m
.75229 .00961 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.798 .01613 m
.81644 .01613 L
s
.80722 .02535 m
.80722 .00691 L
s
P
p
.7 g
.004 w
.83142 .00961 m
.84446 .02265 L
s
.83142 .02265 m
.84446 .00961 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95431 .00961 m
.96735 .02265 L
s
.95431 .02265 m
.96735 .00961 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0700461 0.97619 0.100768 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(1)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(1)] .28495 .01613 0 0 Mshowa
[(0)] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[(0)] .43856 .01613 0 0 Mshowa
[(0)] .46928 .01613 0 0 Mshowa
[(1)] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(0)] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[(0)] .68433 .01613 0 0 Mshowa
[(0)] .71505 .01613 0 0 Mshowa
[(0)] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[(0)] .80722 .01613 0 0 Mshowa
[(0)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(1)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 351; pictureHeight = 35]
%!
%%Creator: Mathematica
%%AspectRatio: .10323 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00245776 0.952381 [
[ 0 0 0 0 ]
[ 1 .10323 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .10323 L
0 .10323 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00245776 0.97619 0.0331797 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(0)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(1)] .28495 .01613 0 0 Mshowa
[(0)] .31567 .01613 0 0 Mshowa
[(0)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[(1)] .43856 .01613 0 0 Mshowa
[(0)] .46928 .01613 0 0 Mshowa
[(0)] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(1)] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[(1)] .68433 .01613 0 0 Mshowa
[(0)] .71505 .01613 0 0 Mshowa
[(1)] .74578 .01613 0 0 Mshowa
[(1)] .7765 .01613 0 0 Mshowa
[(0)] .80722 .01613 0 0 Mshowa
[(0)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(0)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0362519 0.97619 0.0669739 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06068 .01613 m
.07911 .01613 L
s
.06989 .02535 m
.06989 .00691 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
.7 g
.004 w
.15284 .01613 m
.17127 .01613 L
s
.16206 .02535 m
.16206 .00691 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21429 .01613 m
.23272 .01613 L
s
.2235 .02535 m
.2235 .00691 L
s
P
p
.7 g
.004 w
.24501 .01613 m
.26344 .01613 L
s
.25422 .02535 m
.25422 .00691 L
s
P
p
.7 g
.004 w
.27843 .00961 m
.29146 .02265 L
s
.27843 .02265 m
.29146 .00961 L
s
P
p
.7 g
.004 w
.30915 .00961 m
.32219 .02265 L
s
.30915 .02265 m
.32219 .00961 L
s
P
p
.7 g
.004 w
.33717 .01613 m
.35561 .01613 L
s
.34639 .02535 m
.34639 .00691 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
.7 g
.004 w
.43204 .00961 m
.44507 .02265 L
s
.43204 .02265 m
.44507 .00961 L
s
P
p
.7 g
.004 w
.46006 .01613 m
.47849 .01613 L
s
.46928 .02535 m
.46928 .00691 L
s
P
p
.7 g
.004 w
.49078 .01613 m
.50922 .01613 L
s
.5 .02535 m
.5 .00691 L
s
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
.7 g
.004 w
.55223 .01613 m
.57066 .01613 L
s
.56144 .02535 m
.56144 .00691 L
s
P
p
.7 g
.004 w
.58565 .00961 m
.59868 .02265 L
s
.58565 .02265 m
.59868 .00961 L
s
P
p
.7 g
.004 w
.61367 .01613 m
.6321 .01613 L
s
.62289 .02535 m
.62289 .00691 L
s
P
p
.7 g
.004 w
.64709 .00961 m
.66013 .02265 L
s
.64709 .02265 m
.66013 .00961 L
s
P
p
.7 g
.004 w
.67781 .00961 m
.69085 .02265 L
s
.67781 .02265 m
.69085 .00961 L
s
P
p
.7 g
.004 w
.70854 .00961 m
.72157 .02265 L
s
.70854 .02265 m
.72157 .00961 L
s
P
p
.7 g
.004 w
.73656 .01613 m
.75499 .01613 L
s
.74578 .02535 m
.74578 .00691 L
s
P
p
.7 g
.004 w
.76998 .00961 m
.78301 .02265 L
s
.76998 .02265 m
.78301 .00961 L
s
P
p
.7 g
.004 w
.8007 .00961 m
.81374 .02265 L
s
.8007 .02265 m
.81374 .00961 L
s
P
p
.7 g
.004 w
.82873 .01613 m
.84716 .01613 L
s
.83794 .02535 m
.83794 .00691 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95161 .01613 m
.97005 .01613 L
s
.96083 .02535 m
.96083 .00691 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0700461 0.97619 0.100768 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
0 g
p
p
.06338 .02265 m
.07641 .00961 L
s
P
p
.0914 .01613 m
.10983 .01613 L
s
P
p
.12482 .02265 m
.13785 .00961 L
s
P
p
.15554 .02265 m
.16858 .00961 L
s
P
p
.18626 .02265 m
.1993 .00961 L
s
P
p
.21699 .00961 m
.23002 .02265 L
s
P
p
.24771 .00961 m
.26074 .02265 L
s
P
p
.27573 .01613 m
.29416 .01613 L
s
P
p
.30915 .00961 m
.32219 .02265 L
s
P
p
.33987 .02265 m
.35291 .00961 L
s
P
p
.37711 .00691 m
.37711 .02535 L
s
P
p
.40783 .00691 m
.40783 .02535 L
s
P
p
.43856 .00691 m
.43856 .02535 L
s
P
p
.46928 .00691 m
.46928 .02535 L
s
P
p
.49348 .02265 m
.50652 .00961 L
s
P
p
.5242 .00961 m
.53724 .02265 L
s
P
p
.56144 .00691 m
.56144 .02535 L
s
P
p
.59217 .00691 m
.59217 .02535 L
s
P
p
.61637 .00961 m
.6294 .02265 L
s
P
p
.64439 .01613 m
.66283 .01613 L
s
P
p
.68433 .00691 m
.68433 .02535 L
s
P
p
.70854 .00961 m
.72157 .02265 L
s
P
p
.73926 .00961 m
.75229 .02265 L
s
P
p
.7765 .00691 m
.7765 .02535 L
s
P
p
.80722 .00691 m
.80722 .02535 L
s
P
p
.83142 .00961 m
.84446 .02265 L
s
P
p
.86215 .02265 m
.87518 .00961 L
s
P
p
.89939 .00691 m
.89939 .02535 L
s
P
p
.92359 .02265 m
.93662 .00961 L
s
P
p
.95431 .02265 m
.96735 .00961 L
s
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 401; pictureHeight = 35]
%!
%%Creator: Mathematica
%%AspectRatio: .10323 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00245776 0.952381 [
[ 0 0 0 0 ]
[ 1 .10323 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .10323 L
0 .10323 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00245776 0.97619 0.0331797 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(0)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(1)] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(1)] .28495 .01613 0 0 Mshowa
[(1)] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[(1)] .43856 .01613 0 0 Mshowa
[(0)] .46928 .01613 0 0 Mshowa
[(0)] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(1)] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[(1)] .68433 .01613 0 0 Mshowa
[(1)] .71505 .01613 0 0 Mshowa
[(1)] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[(0)] .80722 .01613 0 0 Mshowa
[(0)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(0)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0362519 0.97619 0.0669739 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06068 .01613 m
.07911 .01613 L
s
.06989 .02535 m
.06989 .00691 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
.7 g
.004 w
.15284 .01613 m
.17127 .01613 L
s
.16206 .02535 m
.16206 .00691 L
s
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
.7 g
.004 w
.24501 .01613 m
.26344 .01613 L
s
.25422 .02535 m
.25422 .00691 L
s
P
p
.7 g
.004 w
.27843 .00961 m
.29146 .02265 L
s
.27843 .02265 m
.29146 .00961 L
s
P
p
.7 g
.004 w
.30645 .01613 m
.32488 .01613 L
s
.31567 .02535 m
.31567 .00691 L
s
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
.7 g
.004 w
.43204 .00961 m
.44507 .02265 L
s
.43204 .02265 m
.44507 .00961 L
s
P
p
.7 g
.004 w
.46276 .00961 m
.4758 .02265 L
s
.46276 .02265 m
.4758 .00961 L
s
P
p
.7 g
.004 w
.49078 .01613 m
.50922 .01613 L
s
.5 .02535 m
.5 .00691 L
s
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
.7 g
.004 w
.55493 .00961 m
.56796 .02265 L
s
.55493 .02265 m
.56796 .00961 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
.7 g
.004 w
.67781 .00961 m
.69085 .02265 L
s
.67781 .02265 m
.69085 .00961 L
s
P
p
.7 g
.004 w
.70584 .01613 m
.72427 .01613 L
s
.71505 .02535 m
.71505 .00691 L
s
P
p
.7 g
.004 w
.73656 .01613 m
.75499 .01613 L
s
.74578 .02535 m
.74578 .00691 L
s
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
.7 g
.004 w
.8007 .00961 m
.81374 .02265 L
s
.8007 .02265 m
.81374 .00961 L
s
P
p
.7 g
.004 w
.82873 .01613 m
.84716 .01613 L
s
.83794 .02535 m
.83794 .00691 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95161 .01613 m
.97005 .01613 L
s
.96083 .02535 m
.96083 .00691 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0700461 0.97619 0.100768 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
0 g
p
p
.06989 .00691 m
.06989 .02535 L
s
P
p
.0914 .01613 m
.10983 .01613 L
s
P
p
.12482 .02265 m
.13785 .00961 L
s
P
p
.15284 .01613 m
.17127 .01613 L
s
P
p
.18626 .02265 m
.1993 .00961 L
s
P
p
.2235 .00691 m
.2235 .02535 L
s
P
p
.25422 .00691 m
.25422 .02535 L
s
P
p
.27843 .02265 m
.29146 .00961 L
s
P
p
.30915 .00961 m
.32219 .02265 L
s
P
p
.34639 .00691 m
.34639 .02535 L
s
P
p
.37711 .00691 m
.37711 .02535 L
s
P
p
.40783 .00691 m
.40783 .02535 L
s
P
p
.43204 .02265 m
.44507 .00961 L
s
P
p
.46928 .00691 m
.46928 .02535 L
s
P
p
.5 .00691 m
.5 .02535 L
s
P
p
.5242 .00961 m
.53724 .02265 L
s
P
p
.56144 .00691 m
.56144 .02535 L
s
P
p
.58565 .00961 m
.59868 .02265 L
s
P
p
.61367 .01613 m
.6321 .01613 L
s
P
p
.64709 .02265 m
.66013 .00961 L
s
P
p
.67781 .02265 m
.69085 .00961 L
s
P
p
.70854 .00961 m
.72157 .02265 L
s
P
p
.73656 .01613 m
.75499 .01613 L
s
P
p
.76998 .02265 m
.78301 .00961 L
s
P
p
.8007 .00961 m
.81374 .02265 L
s
P
p
.83794 .00691 m
.83794 .02535 L
s
P
p
.86215 .02265 m
.87518 .00961 L
s
P
p
.89939 .00691 m
.89939 .02535 L
s
P
p
.92359 .02265 m
.93662 .00961 L
s
P
p
.96083 .00691 m
.96083 .02535 L
s
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 330; pictureHeight = 45]
%!
%%Creator: Mathematica
%%AspectRatio: .13871 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00330261 0.952381 [
[ 0 0 0 0 ]
[ 1 .13871 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .13871 L
0 .13871 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00330261 0.97619 0.0340246 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[( )] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(1)] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[( )] .59217 .01613 0 0 Mshowa
[( )] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[( )] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[( )] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0370968 0.97619 0.0678187 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
P
p
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
P
p
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0708909 0.97619 0.101613 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
P
p
P
p
.7 g
.004 w
.12482 .00961 m
.13785 .02265 L
s
.12482 .02265 m
.13785 .00961 L
s
P
p
P
p
.7 g
.004 w
.18626 .00961 m
.1993 .02265 L
s
.18626 .02265 m
.1993 .00961 L
s
P
p
.7 g
.004 w
.21699 .00961 m
.23002 .02265 L
s
.21699 .02265 m
.23002 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.33987 .00961 m
.35291 .02265 L
s
.33987 .02265 m
.35291 .00961 L
s
P
p
.7 g
.004 w
.3679 .01613 m
.38633 .01613 L
s
.37711 .02535 m
.37711 .00691 L
s
P
p
.7 g
.004 w
.39862 .01613 m
.41705 .01613 L
s
.40783 .02535 m
.40783 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.5242 .00961 m
.53724 .02265 L
s
.5242 .02265 m
.53724 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.64439 .01613 m
.66283 .01613 L
s
.65361 .02535 m
.65361 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.76728 .01613 m
.78571 .01613 L
s
.7765 .02535 m
.7765 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.89017 .01613 m
.9086 .01613 L
s
.89939 .02535 m
.89939 .00691 L
s
P
p
P
p
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.104685 0.97619 0.135407 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[( )] .10061 .01613 0 0 Mshowa
[(1)] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[(1)] .19278 .01613 0 0 Mshowa
[(0)] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[(1)] .34639 .01613 0 0 Mshowa
[(0)] .37711 .01613 0 0 Mshowa
[(0)] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[(0)] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[( )] .59217 .01613 0 0 Mshowa
[( )] .62289 .01613 0 0 Mshowa
[(1)] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[(0)] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[( )] .86866 .01613 0 0 Mshowa
[(0)] .89939 .01613 0 0 Mshowa
[( )] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 410; pictureHeight = 69; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .17419 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.00414747 0.952381 [
[ 0 0 0 0 ]
[ 1 .17419 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .17419 L
0 .17419 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.00414747 0.97619 0.0348694 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[( )] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[( )] .13134 .01613 0 0 Mshowa
[( )] .16206 .01613 0 0 Mshowa
[( )] .19278 .01613 0 0 Mshowa
[( )] .2235 .01613 0 0 Mshowa
[( )] .25422 .01613 0 0 Mshowa
[( )] .28495 .01613 0 0 Mshowa
[( )] .31567 .01613 0 0 Mshowa
[( )] .34639 .01613 0 0 Mshowa
[( )] .37711 .01613 0 0 Mshowa
[( )] .40783 .01613 0 0 Mshowa
[( )] .43856 .01613 0 0 Mshowa
[( )] .46928 .01613 0 0 Mshowa
[( )] .5 .01613 0 0 Mshowa
[( )] .53072 .01613 0 0 Mshowa
[( )] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(1)] .62289 .01613 0 0 Mshowa
[( )] .65361 .01613 0 0 Mshowa
[( )] .68433 .01613 0 0 Mshowa
[( )] .71505 .01613 0 0 Mshowa
[( )] .74578 .01613 0 0 Mshowa
[( )] .7765 .01613 0 0 Mshowa
[( )] .80722 .01613 0 0 Mshowa
[( )] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[( )] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[( )] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0379416 0.97619 0.0686636 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.004 w
newpath
.06989 .01613 .01229 0 365.73 arc
s
.07358 .01982 m
.07358 .01982 .00184 0 365.73 arc
F
.06621 .01982 m
.06621 .01982 .00184 0 365.73 arc
F
.06621 .01121 m
.06743 .01367 L
.07235 .01367 L
.07358 .01121 L
s
P
p
.004 w
newpath
.10061 .01613 .01229 0 365.73 arc
s
.1043 .01982 m
.1043 .01982 .00184 0 365.73 arc
F
.09693 .01982 m
.09693 .01982 .00184 0 365.73 arc
F
.09693 .01367 m
.09816 .01121 L
.10307 .01121 L
.1043 .01367 L
s
P
p
P
p
.004 w
newpath
.16206 .01613 .01229 0 365.73 arc
s
.16575 .01982 m
.16575 .01982 .00184 0 365.73 arc
F
.15837 .01982 m
.15837 .01982 .00184 0 365.73 arc
F
.15837 .01121 m
.1596 .01367 L
.16452 .01367 L
.16575 .01121 L
s
P
p
P
p
P
p
.004 w
newpath
.25422 .01613 .01229 0 365.73 arc
s
.25791 .01982 m
.25791 .01982 .00184 0 365.73 arc
F
.25054 .01982 m
.25054 .01982 .00184 0 365.73 arc
F
.25054 .01121 m
.25177 .01367 L
.25668 .01367 L
.25791 .01121 L
s
P
p
.004 w
newpath
.28495 .01613 .01229 0 365.73 arc
s
.28863 .01982 m
.28863 .01982 .00184 0 365.73 arc
F
.28126 .01982 m
.28126 .01982 .00184 0 365.73 arc
F
.28126 .01121 m
.28249 .01367 L
.2874 .01367 L
.28863 .01121 L
s
P
p
.004 w
newpath
.31567 .01613 .01229 0 365.73 arc
s
.31935 .01982 m
.31935 .01982 .00184 0 365.73 arc
F
.31198 .01982 m
.31198 .01982 .00184 0 365.73 arc
F
.31198 .01121 m
.31321 .01367 L
.31813 .01367 L
.31935 .01121 L
s
P
p
P
p
P
p
P
p
.004 w
newpath
.43856 .01613 .01229 0 365.73 arc
s
.44224 .01982 m
.44224 .01982 .00184 0 365.73 arc
F
.43487 .01982 m
.43487 .01982 .00184 0 365.73 arc
F
.43487 .01121 m
.4361 .01367 L
.44101 .01367 L
.44224 .01121 L
s
P
p
.004 w
newpath
.46928 .01613 .01229 0 365.73 arc
s
.47296 .01982 m
.47296 .01982 .00184 0 365.73 arc
F
.46559 .01982 m
.46559 .01982 .00184 0 365.73 arc
F
.46559 .01121 m
.46682 .01367 L
.47174 .01367 L
.47296 .01121 L
s
P
p
.004 w
newpath
.5 .01613 .01229 0 365.73 arc
s
.50369 .01982 m
.50369 .01982 .00184 0 365.73 arc
F
.49631 .01982 m
.49631 .01982 .00184 0 365.73 arc
F
.49631 .01121 m
.49754 .01367 L
.50246 .01367 L
.50369 .01121 L
s
P
p
P
p
.004 w
newpath
.56144 .01613 .01229 0 365.73 arc
s
.56513 .01982 m
.56513 .01982 .00184 0 365.73 arc
F
.55776 .01982 m
.55776 .01982 .00184 0 365.73 arc
F
.55776 .01121 m
.55899 .01367 L
.5639 .01367 L
.56513 .01121 L
s
P
p
.004 w
newpath
.59217 .01613 .01229 0 365.73 arc
s
.59585 .01982 m
.59585 .01982 .00184 0 365.73 arc
F
.58848 .01982 m
.58848 .01982 .00184 0 365.73 arc
F
.58848 .01367 m
.58971 .01121 L
.59462 .01121 L
.59585 .01367 L
s
P
p
.004 w
newpath
.62289 .01613 .01229 0 365.73 arc
s
.62657 .01982 m
.62657 .01982 .00184 0 365.73 arc
F
.6192 .01982 m
.6192 .01982 .00184 0 365.73 arc
F
.6192 .01367 m
.62043 .01121 L
.62535 .01121 L
.62657 .01367 L
s
P
p
P
p
.004 w
newpath
.68433 .01613 .01229 0 365.73 arc
s
.68802 .01982 m
.68802 .01982 .00184 0 365.73 arc
F
.68065 .01982 m
.68065 .01982 .00184 0 365.73 arc
F
.68065 .01121 m
.68187 .01367 L
.68679 .01367 L
.68802 .01121 L
s
P
p
.004 w
newpath
.71505 .01613 .01229 0 365.73 arc
s
.71874 .01982 m
.71874 .01982 .00184 0 365.73 arc
F
.71137 .01982 m
.71137 .01982 .00184 0 365.73 arc
F
.71137 .01121 m
.7126 .01367 L
.71751 .01367 L
.71874 .01121 L
s
P
p
.004 w
newpath
.74578 .01613 .01229 0 365.73 arc
s
.74946 .01982 m
.74946 .01982 .00184 0 365.73 arc
F
.74209 .01982 m
.74209 .01982 .00184 0 365.73 arc
F
.74209 .01121 m
.74332 .01367 L
.74823 .01367 L
.74946 .01121 L
s
P
p
P
p
.004 w
newpath
.80722 .01613 .01229 0 365.73 arc
s
.81091 .01982 m
.81091 .01982 .00184 0 365.73 arc
F
.80353 .01982 m
.80353 .01982 .00184 0 365.73 arc
F
.80353 .01121 m
.80476 .01367 L
.80968 .01367 L
.81091 .01121 L
s
P
p
.004 w
newpath
.83794 .01613 .01229 0 365.73 arc
s
.84163 .01982 m
.84163 .01982 .00184 0 365.73 arc
F
.83425 .01982 m
.83425 .01982 .00184 0 365.73 arc
F
.83425 .01121 m
.83548 .01367 L
.8404 .01367 L
.84163 .01121 L
s
P
p
.004 w
newpath
.86866 .01613 .01229 0 365.73 arc
s
.87235 .01982 m
.87235 .01982 .00184 0 365.73 arc
F
.86498 .01982 m
.86498 .01982 .00184 0 365.73 arc
F
.86498 .01367 m
.86621 .01121 L
.87112 .01121 L
.87235 .01367 L
s
P
p
P
p
.004 w
newpath
.93011 .01613 .01229 0 365.73 arc
s
.93379 .01982 m
.93379 .01982 .00184 0 365.73 arc
F
.92642 .01982 m
.92642 .01982 .00184 0 365.73 arc
F
.92642 .01367 m
.92765 .01121 L
.93257 .01121 L
.93379 .01367 L
s
P
p
.004 w
newpath
.96083 .01613 .01229 0 365.73 arc
s
.96452 .01982 m
.96452 .01982 .00184 0 365.73 arc
F
.95714 .01982 m
.95714 .01982 .00184 0 365.73 arc
F
.95714 .01121 m
.95837 .01367 L
.96329 .01367 L
.96452 .01121 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.0717358 0.97619 0.102458 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
[(0)] .06989 .01613 0 0 Mshowa
[(1)] .10061 .01613 0 0 Mshowa
[( )] .13134 .01613 0 0 Mshowa
[(1)] .16206 .01613 0 0 Mshowa
[( )] .19278 .01613 0 0 Mshowa
[( )] .2235 .01613 0 0 Mshowa
[(0)] .25422 .01613 0 0 Mshowa
[(1)] .28495 .01613 0 0 Mshowa
[(1)] .31567 .01613 0 0 Mshowa
[( )] .34639 .01613 0 0 Mshowa
[( )] .37711 .01613 0 0 Mshowa
[( )] .40783 .01613 0 0 Mshowa
[(1)] .43856 .01613 0 0 Mshowa
[(0)] .46928 .01613 0 0 Mshowa
[(0)] .5 .01613 0 0 Mshowa
[( )] .53072 .01613 0 0 Mshowa
[(0)] .56144 .01613 0 0 Mshowa
[(0)] .59217 .01613 0 0 Mshowa
[(1)] .62289 .01613 0 0 Mshowa
[( )] .65361 .01613 0 0 Mshowa
[(1)] .68433 .01613 0 0 Mshowa
[(1)] .71505 .01613 0 0 Mshowa
[(1)] .74578 .01613 0 0 Mshowa
[( )] .7765 .01613 0 0 Mshowa
[(0)] .80722 .01613 0 0 Mshowa
[(0)] .83794 .01613 0 0 Mshowa
[(1)] .86866 .01613 0 0 Mshowa
[( )] .89939 .01613 0 0 Mshowa
[(1)] .93011 .01613 0 0 Mshowa
[(0)] .96083 .01613 0 0 Mshowa
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.10553 0.97619 0.136252 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06068 .01613 m
.07911 .01613 L
s
.06989 .02535 m
.06989 .00691 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
P
p
.7 g
.004 w
.15284 .01613 m
.17127 .01613 L
s
.16206 .02535 m
.16206 .00691 L
s
P
p
P
p
P
p
.7 g
.004 w
.24501 .01613 m
.26344 .01613 L
s
.25422 .02535 m
.25422 .00691 L
s
P
p
.7 g
.004 w
.27843 .00961 m
.29146 .02265 L
s
.27843 .02265 m
.29146 .00961 L
s
P
p
.7 g
.004 w
.30645 .01613 m
.32488 .01613 L
s
.31567 .02535 m
.31567 .00691 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.43204 .00961 m
.44507 .02265 L
s
.43204 .02265 m
.44507 .00961 L
s
P
p
.7 g
.004 w
.46276 .00961 m
.4758 .02265 L
s
.46276 .02265 m
.4758 .00961 L
s
P
p
.7 g
.004 w
.49078 .01613 m
.50922 .01613 L
s
.5 .02535 m
.5 .00691 L
s
P
p
P
p
.7 g
.004 w
.55493 .00961 m
.56796 .02265 L
s
.55493 .02265 m
.56796 .00961 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
P
p
.7 g
.004 w
.67781 .00961 m
.69085 .02265 L
s
.67781 .02265 m
.69085 .00961 L
s
P
p
.7 g
.004 w
.70584 .01613 m
.72427 .01613 L
s
.71505 .02535 m
.71505 .00691 L
s
P
p
.7 g
.004 w
.73656 .01613 m
.75499 .01613 L
s
.74578 .02535 m
.74578 .00691 L
s
P
p
P
p
.7 g
.004 w
.8007 .00961 m
.81374 .02265 L
s
.8007 .02265 m
.81374 .00961 L
s
P
p
.7 g
.004 w
.82873 .01613 m
.84716 .01613 L
s
.83794 .02535 m
.83794 .00691 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95161 .01613 m
.97005 .01613 L
s
.96083 .02535 m
.96083 .00691 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.139324 0.97619 0.170046 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.030722 0.000768049 0.030722 [
[ 0 0 0 0 ]
[ 1 .03226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
P
0 0 m
1 0 L
1 .03226 L
0 .03226 L
closepath
clip
newpath
p
p
.7 g
.004 w
.06338 .00961 m
.07641 .02265 L
s
.06338 .02265 m
.07641 .00961 L
s
P
p
.7 g
.004 w
.0914 .01613 m
.10983 .01613 L
s
.10061 .02535 m
.10061 .00691 L
s
P
p
P
p
.7 g
.004 w
.15554 .00961 m
.16858 .02265 L
s
.15554 .02265 m
.16858 .00961 L
s
P
p
P
p
P
p
.7 g
.004 w
.24771 .00961 m
.26074 .02265 L
s
.24771 .02265 m
.26074 .00961 L
s
P
p
.7 g
.004 w
.27573 .01613 m
.29416 .01613 L
s
.28495 .02535 m
.28495 .00691 L
s
P
p
.7 g
.004 w
.30915 .00961 m
.32219 .02265 L
s
.30915 .02265 m
.32219 .00961 L
s
P
p
P
p
P
p
P
p
.7 g
.004 w
.42934 .01613 m
.44777 .01613 L
s
.43856 .02535 m
.43856 .00691 L
s
P
p
.7 g
.004 w
.46006 .01613 m
.47849 .01613 L
s
.46928 .02535 m
.46928 .00691 L
s
P
p
.7 g
.004 w
.49348 .00961 m
.50652 .02265 L
s
.49348 .02265 m
.50652 .00961 L
s
P
p
P
p
.7 g
.004 w
.55223 .01613 m
.57066 .01613 L
s
.56144 .02535 m
.56144 .00691 L
s
P
p
.7 g
.004 w
.58295 .01613 m
.60138 .01613 L
s
.59217 .02535 m
.59217 .00691 L
s
P
p
.7 g
.004 w
.61637 .00961 m
.6294 .02265 L
s
.61637 .02265 m
.6294 .00961 L
s
P
p
P
p
.7 g
.004 w
.67512 .01613 m
.69355 .01613 L
s
.68433 .02535 m
.68433 .00691 L
s
P
p
.7 g
.004 w
.70854 .00961 m
.72157 .02265 L
s
.70854 .02265 m
.72157 .00961 L
s
P
p
.7 g
.004 w
.73926 .00961 m
.75229 .02265 L
s
.73926 .02265 m
.75229 .00961 L
s
P
p
P
p
.7 g
.004 w
.798 .01613 m
.81644 .01613 L
s
.80722 .02535 m
.80722 .00691 L
s
P
p
.7 g
.004 w
.83142 .00961 m
.84446 .02265 L
s
.83142 .02265 m
.84446 .00961 L
s
P
p
.7 g
.004 w
.86215 .00961 m
.87518 .02265 L
s
.86215 .02265 m
.87518 .00961 L
s
P
p
P
p
.7 g
.004 w
.92359 .00961 m
.93662 .02265 L
s
.92359 .02265 m
.93662 .00961 L
s
P
p
.7 g
.004 w
.95431 .00961 m
.96735 .02265 L
s
.95431 .02265 m
.96735 .00961 L
s
P
.7 g
1 Mabswid
.05453 .00077 m
.08525 .00077 L
.08525 .03149 L
.05453 .03149 L
.05453 .00077 L
s
.08525 .00077 m
.11598 .00077 L
.11598 .03149 L
.08525 .03149 L
.08525 .00077 L
s
.11598 .00077 m
.1467 .00077 L
.1467 .03149 L
.11598 .03149 L
.11598 .00077 L
s
.1467 .00077 m
.17742 .00077 L
.17742 .03149 L
.1467 .03149 L
.1467 .00077 L
s
.17742 .00077 m
.20814 .00077 L
.20814 .03149 L
.17742 .03149 L
.17742 .00077 L
s
.20814 .00077 m
.23886 .00077 L
.23886 .03149 L
.20814 .03149 L
.20814 .00077 L
s
.23886 .00077 m
.26959 .00077 L
.26959 .03149 L
.23886 .03149 L
.23886 .00077 L
s
.26959 .00077 m
.30031 .00077 L
.30031 .03149 L
.26959 .03149 L
.26959 .00077 L
s
.30031 .00077 m
.33103 .00077 L
.33103 .03149 L
.30031 .03149 L
.30031 .00077 L
s
.33103 .00077 m
.36175 .00077 L
.36175 .03149 L
.33103 .03149 L
.33103 .00077 L
s
.36175 .00077 m
.39247 .00077 L
.39247 .03149 L
.36175 .03149 L
.36175 .00077 L
s
.39247 .00077 m
.4232 .00077 L
.4232 .03149 L
.39247 .03149 L
.39247 .00077 L
s
.4232 .00077 m
.45392 .00077 L
.45392 .03149 L
.4232 .03149 L
.4232 .00077 L
s
.45392 .00077 m
.48464 .00077 L
.48464 .03149 L
.45392 .03149 L
.45392 .00077 L
s
.48464 .00077 m
.51536 .00077 L
.51536 .03149 L
.48464 .03149 L
.48464 .00077 L
s
.51536 .00077 m
.54608 .00077 L
.54608 .03149 L
.51536 .03149 L
.51536 .00077 L
s
.54608 .00077 m
.5768 .00077 L
.5768 .03149 L
.54608 .03149 L
.54608 .00077 L
s
.5768 .00077 m
.60753 .00077 L
.60753 .03149 L
.5768 .03149 L
.5768 .00077 L
s
.60753 .00077 m
.63825 .00077 L
.63825 .03149 L
.60753 .03149 L
.60753 .00077 L
s
.63825 .00077 m
.66897 .00077 L
.66897 .03149 L
.63825 .03149 L
.63825 .00077 L
s
.66897 .00077 m
.69969 .00077 L
.69969 .03149 L
.66897 .03149 L
.66897 .00077 L
s
.69969 .00077 m
.73041 .00077 L
.73041 .03149 L
.69969 .03149 L
.69969 .00077 L
s
.73041 .00077 m
.76114 .00077 L
.76114 .03149 L
.73041 .03149 L
.73041 .00077 L
s
.76114 .00077 m
.79186 .00077 L
.79186 .03149 L
.76114 .03149 L
.76114 .00077 L
s
.79186 .00077 m
.82258 .00077 L
.82258 .03149 L
.79186 .03149 L
.79186 .00077 L
s
.82258 .00077 m
.8533 .00077 L
.8533 .03149 L
.82258 .03149 L
.82258 .00077 L
s
.8533 .00077 m
.88402 .00077 L
.88402 .03149 L
.8533 .03149 L
.8533 .00077 L
s
.88402 .00077 m
.91475 .00077 L
.91475 .03149 L
.88402 .03149 L
.88402 .00077 L
s
.91475 .00077 m
.94547 .00077 L
.94547 .03149 L
.91475 .03149 L
.91475 .00077 L
s
.94547 .00077 m
.97619 .00077 L
.97619 .03149 L
.94547 .03149 L
.94547 .00077 L
s
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
$Aborted
;[o]
$Aborted
:[font = subsection; inactive; Cclosed; preserveAspect; fontColorRed = 65535; fontSize = 12; startGroup]
Code for Simulator in here ...
:[font = input; initialization; preserveAspect; startGroup]
*)
DistributeKeyUsingQKD[desiredProbOfDetection_, nKeyBits_, opts___]:=
	Module[{nTestBits, bitsA},
		nTestBits = NumberOfBitsForDetectability[desiredProbOfDetection];
		bitsA = Table[Random[Integer,{0,1}], {nTestBits + 4 * nKeyBits}];
		QKD[bitsA, nTestBits, opts]
	]
	
DistributeKeyUsingQKD::usage =
	"DistributeKeyUsingQKD[p, n, options] generates a simulation of \
	quantum key distribution.  The desired probability of detecting \
	eavesdropping is p and the desired number of bits in the \
	secret shared key is n. If the option Eavesdropping->True is \
	given, then the actions of a malicious intermediary Eve are \
	simulated. If the option Eavesdropping->False is given, then \
	the simulator runs without Eve intervening.";

Options[QKD] = {Eavesdropping->True};

QKD[bitString_String, nTestBits_Integer, opts___]:= 
	QKD[Map[ToExpression, Characters[bitString]], nTestBits, opts]
	
QKD[bits_, nTestBits_, opts___]:=
	Module[{photonsAliceToBob, polarizersEve, bitsEve,
	        photonsEveToBob, polarizersBob, bitsBob, whichBitsToTest,
	        estErrorRate},
	        
		evePresentQ = Eavesdropping /. {opts} /. Options[QKD];
		Print["evePresentQ = ", evePresentQ];
		
	                (* Alice *)
		polarizersAlice   = PickPolarizers[ Length[bits] ];
		photonsAliceToBob = BitsToPhotons[bits, polarizersAlice];
		PortrayEncoding[bits, polarizersAlice, photonsAliceToBob];
		
		polarizersBob     = PickPolarizers[ Length[bits] ];
		    (* I moved Bob's pick of polarizers ahead of anything Eve does
		       so that we can set a seed in the random number generator
		       that allows us to compare what Bob sees with and without 
		       eavesdropping (assuming Alice makes the same choices for 
		       bits and her polarizers and assuming Bob makes the same choices 
		       for his polarizers. If this code was after Eve then I could
		       not ensure Bob picked the same set of polarizers. *)
		
		            (* Eve *)
		If[evePresentQ,
		   (polarizersEve     = PickPolarizers[ Length[photonsAliceToBob] ];
		    bitsEve           = PhotonsToBits[photonsAliceToBob,polarizersEve];
		    photonsEveToBob   = BitsToPhotons[bitsEve, polarizersEve];
		    PortrayDecoding[photonsAliceToBob, polarizersEve, bitsEve]
		   ),
		   (polarizersEve     = polarizersAlice;
		    photonsEveToBob   = photonsAliceToBob
		   )
		  ];
		
		            (* Bob *)
		bitsBob           = PhotonsToBits[photonsEveToBob,polarizersBob];
		PortrayDecoding[photonsEveToBob, polarizersBob, bitsBob];
		
		            (* Estimate Error Rate *)
		
		whichBitsToTest   = ChooseBitsToTest[polarizersAlice, polarizersBob, nTestBits];
		estErrorRate      = EstimateErrorRate[bits, bitsBob, whichBitsToTest];
		PortrayEavesdroppingTest[bits, polarizersAlice, bitsBob, polarizersBob, whichBitsToTest];
		PortrayKeyExchange[polarizersAlice, bits, polarizersBob, bitsBob, 
		                   Map[{#}&, whichBitsToTest]];
		
		            (* Do Key Exchange or Abort *)
		If[EavesdroppingQ[estErrorRate],
		   DoNotExchangeKey[],
		   ExchangeKey[polarizersAlice, bits, polarizersBob, bitsBob, whichBitsToTest]
		  ]
	]
	

(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "bitsA"
     is similar to existing symbol "bits".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "EavesdroppingQ"
     is similar to existing symbol "Eavesdropping".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "bitsA"
     is similar to existing symbol "bits".
:[font = message; inactive; preserveAspect; endGroup]
General::spell1: Possible spelling error: new symbol name "EavesdroppingQ"
     is similar to existing symbol "Eavesdropping".
:[font = input; initialization; preserveAspect]
*)
ChooseBitsToTest[polarizersA_, polarizersB_, nTestBits_]:=
	Module[{candidates},
		candidates = Complement[MapThread[If[#1===#2, #3, Null]&, 
	                                      {polarizersA,
	                                       polarizersB,
	                                       Range[Length[polarizersA]]
	                                      }
	                                     ],
	                            {Null}];
	                            Print[candidates];
	    If[nTestBits <= Length[candidates],
	       RandomKSubset[candidates, nTestBits],
	       Message[ChooseBitsToTest::insufficientMatches]; Abort[]
	      ]
	]

ChooseBitsToTest::insufficientMatches =
	"Alice and Bob do not have enough polarizers set at the same angle \
	to attain the probability of detecting eavesdropping that you seek. \
	This is just bad luck ... try again.";
		    
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Select Between Rectilinear and Diagional Polarizers at Random
:[font = input; initialization; preserveAspect; endGroup]
*)
PickPolarizers[n_]:=
	Table[If[CoinToss[]===Heads, RectilinearBasis, DiagonalBasis], {n}]	
	
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Mapping Bits into Polarized Photons
:[font = input; initialization; preserveAspect; endGroup]
*)
BitStringToPolarizedPhotons[bitString_]:=
	Map[{#[[2]], #[[3]]}&, EncodeBitString[bitString]]
	
BitsToPhotons[bits_, polarizers_]:=
	MapThread[BitToPhoton[#1, #2]&, {bits, polarizers}]

BitToPhoton[0, RectilinearBasis]:= {RectilinearBasis, ket[0]}
BitToPhoton[1, RectilinearBasis]:= {RectilinearBasis, ket[1]}
BitToPhoton[0, DiagonalBasis]:=    {DiagonalBasis, ket[0]}
BitToPhoton[1, DiagonalBasis]:=    {DiagonalBasis, ket[1]}
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Measuring Polarized Photons to Extract Bits
:[font = text; inactive; preserveAspect]
If the sebder and receiver both used the same basis, then the answer is certain and guaranteed correct (assuming perfection in measurement). If the sender and receiver are using polarizers at 45 degree to one another, then the bit obtained from the measurement is effectively random.
:[font = input; initialization; preserveAspect; endGroup]
*)
PhotonsToBits[polarizedPhotons_, polarizers_]:=
	MapThread[If[#1[[1]] === #2,
	             #1[[2,1]],
	             Random[Integer,{0,1}]]&, {polarizedPhotons, polarizers}]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Measuring the Polarizations of a Stream of Photons
:[font = input; preserveAspect; endGroup]
MeasurePolarizations[photons_]:=
	Map[MeasurePolarization, photons]

MeasurePolarization[{ket_, unknownBasis_}]:=
	Module[{measurementBasis},
		measurementBasis = ChooseBasisForMeasurement[];
		Which[measurementBasis === unknownBasis, ket,
		      measurementBasis =!= unknownBasis, RandomAnswer[]
		       
ChooseBasisForMeasurement[]:=
	If[CoinToss[]===Heads, RectilinearBasis, DiagonalBasis]
:[font = subsubsection; inactive; preserveAspect; startGroup]
Estimate Error Rate Step
:[font = input; initialization; preserveAspect; startGroup]
*)
EstimateErrorRate[bitsA_, bitsB_, indices_]:=
	Module[{testBitsA, testBitsB, comparisons},
		testBitsA   = Map[bitsA[[#]]&, indices];
		testBitsB   = Map[bitsB[[#]]&, indices];
		comparisons = MapThread[If[#1 === #2, Right, Wrong]&, 
		                        {testBitsA, testBitsB}];
		N[Count[comparisons, Wrong] / Length[comparisons]]
	]
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "testBitsB"
     is similar to existing symbol "testBitsA".
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "testBitsB"
     is similar to existing symbol "testBitsA".
:[font = subsubsection; inactive; preserveAspect; startGroup]
Criterion for Whether Eavesdropping is Detected
:[font = text; inactive; preserveAspect]
This method for detecting eavesdropping is guaranteed to what probability? Is this criterion True? What is  the uncertainty on the estimate?
:[font = input; initialization; preserveAspect; endGroup]
*)
EavesdroppingQ[estimatedErrorRate_]:=
	If[estimatedErrorRate > 0, True, False]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Key Exchange Step
:[font = input; initialization; preserveAspect; startGroup]
*)
DoNotExchangeKey[]:=
	(Print["Channel is insecure! Do not exchange a key."]; Abort[])

ExchangeKey[polarizersA_, bitsA_, polarizersB_, bitsB_, indices_]:=
	Module[{throwOuts, polarTypesA, secretBitsA, polarTypesB, secretBitsB,
	        positions},
		throwOuts = Map[{#}&, indices];
		polarTypesA = Delete[polarizersA, throwOuts];
		secretBitsA = Delete[bitsA, throwOuts];
		polarTypesB = Delete[polarizersB, throwOuts];
		secretBitsB = Delete[bitsB, throwOuts];
		positions   = SamePolarizersAtPositions[polarTypesA, polarTypesB];
		{
		 Map[secretBitsA[[#]]&, positions],
		 Map[secretBitsB[[#]]&, positions]
		}
	]
		
SamePolarizersAtPositions[polarTypesA_, polarTypesB_]:=
	Module[{matches},
		matches = MapThread[If[#1===#2, Agree, Disagree]&, 
		                    {polarTypesA, polarTypesB}];
		Position[matches, Agree]
	] /; Length[polarTypesA] == Length[polarTypesB]
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "polarTypesB"
     is similar to existing symbol "polarTypesA".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "secretBitsB"
     is similar to existing symbol "secretBitsA".
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "polarTypesB"
     is similar to existing symbol "polarTypesA".
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "secretBitsB"
     is similar to existing symbol "secretBitsA".
:[font = subsubsection; inactive; preserveAspect; startGroup]
Graphics Utilities
:[font = input; initialization; preserveAspect; endGroup]
*)
PortrayEncoding[bits_, polarizers_, photons_]:=
	Module[{g1, g2, g3},
		g1 = PortrayBits[bits];
		g2 = PortrayPolarizers[polarizers];
		g3 = PortrayPolarizedPhotons[photons];
		Show[GraphicsArray[{{g1}, {g2}, {g3}}, AspectRatio->Automatic]]
	]

PortrayDecoding[photons_, polarizers_, bits_]:=
	Module[{g1, g2, g3},
		g1 = PortrayPolarizedPhotons[photons];
		g2 = PortrayPolarizers[polarizers];
		g3 = PortrayBits[bits];
		Show[GraphicsArray[{{g1}, {g2}, {g3}}, AspectRatio->Automatic]]
	]
	
PortrayEavesdroppingTest[bitsA_, polarizersA_, bitsB_, 
                         polarizersB_, indicesToTest_]:=
	Module[{excludeIndices, g1, g2, g3, g4},
		excludeIndices = Map[{#}&, Complement[Range[Length[bitsA]], indicesToTest]];
		g1 = PortrayBits[bitsA, excludeIndices];
		g2 = PortrayPolarizers[polarizersA, excludeIndices];
		g3 = PortrayPolarizers[polarizersB, excludeIndices];
		g4 = PortrayBits[bitsB, excludeIndices];
		Show[GraphicsArray[{{g1}, {g2}, {g3}, {g4}}, AspectRatio->Automatic]]
	]
	
PortrayKeyExchange[polarizersA_, bitsA_, polarizersB_, bitsB_, excludeIndices_]:=
	Module[{g1, g2, g3, g4, matchingBits, g5},
		g1 = PortrayPolarizers[polarizersA, excludeIndices];
		g2 = PortrayPolarizers[polarizersB, excludeIndices];
		g3 = PortrayBits[bitsB, excludeIndices];
		g4 = PortrayMatchingTypes[polarizersA, polarizersB, excludeIndices];
		matchingBits = MapThread[If[#1 === #2, #3, " "]&,
		                         {polarizersA, polarizersB, bitsB}];
		g5 = PortrayBits[matchingBits, excludeIndices];
		
		Show[GraphicsArray[{{g1},{g2},{g3},{g4},{g5}},
		                   AspectRatio->Automatic]]
	]
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Portray Bits
:[font = input; initialization; preserveAspect; endGroup]
*)
PortrayBits[bits_, excludeIndices_:{}]:=
	Module[{usableBits},
		usableBits = ReplacePart[bits, " ", excludeIndices];
		Graphics[Join[MakeBits[usableBits],
	                  MakeBoxes[Length[bits]]],
	             AspectRatio->Automatic]
	]

MakeBoxes[n_]:=
	Join[{GrayLevel[0.7], AbsoluteThickness[1]}, 
	     Table[Line[{{i,0},{i+1,0},{i+1,1},{i,1},{i,0}}], {i, 1, n}]]

MakeBits[bits_]:=
	Table[Text[bits[[i]], {i+0.5, 0.5}], {i, 1, Length[bits]}]


(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Portray Polarizers
:[font = input; initialization; preserveAspect; startGroup]
*)
PortrayPolarizers[polarizers_, excludeIndices_:{}]:=
	Module[{usablePolarizers},
		usablePolarizers = ReplacePart[polarizers, " ", excludeIndices];
		Graphics[Join[MakePolarizers[usablePolarizers],
	                  MakeBoxes[Length[polarizers]]],
	             AspectRatio -> Automatic]
	]
	        
MakePolarizers[polarizers_]:=
	MapIndexed[MakePolarizer, polarizers]

MakePolarizer[RectilinearBasis, {i_}]:= MakeCross[i, 0.6,  0]
MakePolarizer[DiagonalBasis,    {i_}]:= MakeCross[i, 0.6, N[Pi/4]]
MakePolarizer[" ", {i_}]:={}
	
MakeCross[i_, l_, theta_]:=
	Module[{j,s,c},
		j = i + 0.5; s = 0.5 l Sin[theta]; c = 0.5 l Cos[theta];
		{GrayLevel[0.7], Line[{{j-c, 0.5 - s}, {j+c, 0.5 + s}}],
		 GrayLevel[0.7], Line[{{j-s, 0.5 + c}, {j+s, 0.5 - c}}]
		}
	]
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "MakePolarizer"
     is similar to existing symbol "MakePolarizers".
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "MakePolarizer"
     is similar to existing symbol "MakePolarizers".
:[font = subsubsection; inactive; preserveAspect; startGroup]
Portray Polarized Photons
:[font = input; initialization; preserveAspect; startGroup]
*)
PortrayPolarizedPhotons[photons_]:=
	Module[{boxes, lines},
		boxes = MakeBoxes[Length[photons]];
		lines = MapThread[PortrayPolarizedPhoton[#1, #2, 0.6]&, 
	                      {photons, Range[Length[photons]]}];
	    Graphics[Join[boxes, {GrayLevel[0], lines}], AspectRatio->Automatic]
	]

PortrayPolarizedPhoton[{RectilinearBasis, ket[0]}, x0_, l_]:=
	{Line[{{x0+0.5, .5 - l/2}, {x0+0.5, .5 + l/2}}]}

PortrayPolarizedPhoton[{RectilinearBasis, ket[1]}, x0_, l_]:=
	{Line[{{x0 + .5 - l/2, 0.5}, {x0+.5+l/2, 0.5}}]}

PortrayPolarizedPhoton[{DiagonalBasis,    ket[0]}, x0_, l_]:=
	{Line[{{x0 + .5 - l/2 Cos[Pi/4],   .5 - l/2 Sin[Pi/4]}, 
	       {x0 + .5 + l/2 Cos[Pi/4],   .5 + l/2 Sin[Pi/4]}
	      }]
	}

PortrayPolarizedPhoton[{DiagonalBasis,    ket[1]}, x0_, l_]:=
	{Line[{{x0 + .5 - l/2 Cos[Pi/4],   .5 + l/2 Sin[Pi/4]}, 
	       {x0 + .5 + l/2 Cos[Pi/4],   .5 - l/2 Sin[Pi/4]}
	      }]
	}
(*
:[font = message; inactive; preserveAspect]
General::spell1: Possible spelling error: new symbol name "PortrayPolarizedPhoton"
     is similar to existing symbol "PortrayPolarizedPhotons".
:[font = message; inactive; preserveAspect; endGroup; endGroup]
General::spell1: Possible spelling error: new symbol name "PortrayPolarizedPhoton"
     is similar to existing symbol "PortrayPolarizedPhotons".
:[font = subsubsection; inactive; preserveAspect; startGroup]
Portray Matching Types of Polarizers
:[font = input; preserveAspect]
Clear[PortrayMatchingFaces, GoodFace, BadFace]
:[font = input; initialization; preserveAspect; endGroup]
*)
PortrayMatchingTypes[polarizersA_, polarizersB_, indices_]:=
	Module[{faces, usableFaces, boxes},
		faces = MapThread[If[#1 === #2, 
	                         GoodFace[ {#3+0.5, 0.5}, 0.4 ],
	                         BadFace[  {#3+0.5, 0.5}, 0.4 ]
	                        ]&,
	                      {polarizersA, 
	                       polarizersB,
	                       Range[Length[polarizersA]]}
	                     ];
	     usableFaces = ReplacePart[faces, {}, indices];
	     boxes = MakeBoxes[Length[polarizersA]];
	     (* Show[usableFaces, boxes, AspectRatio -> Automatic] *)
	     Graphics[Join[usableFaces, boxes], AspectRatio -> Automatic]
	]

GoodFace[{x0_, y0_}, radius_]:=
	{Circle[{x0,y0}, radius],
	 Disk[{x0 + .3 radius, y0 + .3 radius}, .15 radius],
	 Disk[{x0 - .3 radius, y0 + .3 radius}, .15 radius],
	 Line[{{x0 - .3 radius, y0 - .2 radius},
	       {x0 - .2 radius, y0 - .4 radius},
	       {x0 + .2 radius, y0 - .4 radius},
	       {x0 + .3 radius, y0 - .2 radius}
	      }
	     ]
	}
	         
BadFace[{x0_, y0_}, radius_]:=
	{Circle[{x0,y0}, radius],
	 Disk[{x0 + .3 radius, y0 + .3 radius}, .15 radius],
	 Disk[{x0 - .3 radius, y0 + .3 radius}, .15 radius],
	 Line[{{x0 - .3 radius, y0 - .4 radius},
	       {x0 - .2 radius, y0 - .2 radius},
	       {x0 + .2 radius, y0 - .2 radius},
	       {x0 + .3 radius, y0 - .4 radius}
	      }
	     ]
	}
	          
(*
:[font = subsubsection; inactive; preserveAspect; startGroup]
Random Utilities
:[font = input; initialization; preserveAspect]
*)
CoinToss[]:= If[Random[]<0.5, Heads, Tails]
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup; endGroup]
*)
RandomKSubset[list_, k_]:=
	RandomKSubset[list, k, {}] /; k <= Length[list]
	
RandomKSubset[_, 0, final_]:= final
RandomKSubset[list_, k_, soFar_]:=
	Module[{i},
		i = Random[Integer, {1, Length[list]}];
		RandomKSubset[Drop[list, {i,i}], k-1, Append[soFar, list[[i]] ]]
	]

(*
:[font = section; inactive; preserveAspect; startGroup]
Your experiments here ...
:[font = input; preserveAspect; startGroup]
?DistributeKeyUsingQKD
:[font = print; inactive; preserveAspect; endGroup; endGroup; endGroup]
DistributeKeyUsingQKD[p, n, options] generates a simulation of quantum key distribution.
    The desired probability of detecting eavesdropping is p and the desired number of
   bits in the secret shared key is n. If the option Eavesdropping->True is given, then
   the actions of a malicious intermediary Eve are simulated. If the option
   Eavesdropping->False is given, then the simulator runs without Eve intervening.
^*)
